import os
apesFolder = os.getenv('HOME')+'/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'prod'
######################################################################################
shepherd_jobs = []

run_seeder = True
run_seeder = False

run_hvs_sdr = True
run_hvs_sdr = False

run_musubi = True
run_musubi = False

run_hvs = True
run_hvs = False

submit_job = False
submit_job = True

shepherd_jobs.append(dict(executable=apesFolder+'seeder/build/seeder',
                     template='seeder.template',
                     extension='lua',
                     run_exec = run_seeder,
                     run_command = '',
                     params = [
                       ["nElems",1024],
                       ["dia_ratio",0.5],
                       ["refineBox",'false'],
                       ["refineNozzle","false"]
                       ],
                     additional_params = dict(qVal = 'true',
                                              debug = 'false'),
                     create_subdir = ['mesh', 'debug'],
                     prefix = 'sdr',
                     label = 'seeder'))

shepherd_jobs.append(dict(executable=apesFolder+'harvester/build/harvester',
                     template='harvester_mesh.template',
                     extension='lua',
                     run_exec = False,
                     run_command = 'mpirun -np 4',
                     additional_params = dict(debug = 'false'), 
                     create_subdir = ['harvest'],
                     depend = ['seeder'],
                     create_depend_path = True,
                     label = 'hvs_sdr'))

shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                     template='musubi.template',
                     extension='lua',
                     run_exec = run_musubi,
                     run_command = '',
                     params = [[ "u_mean", 1.0],
                               [ "outletBC", 'outlet_pab']
                              ],
                     additional_params = dict(omega = 1.98), 
                     create_subdir = ['tracking','restart'],
                     create_dir = True,
                     depend = ['seeder'],
                     create_depend_path = True,
                     create_depend_params = True,
                     prefix = 'mus',
                     label = 'musubi'))

shepherd_jobs.append(dict(executable=None,
                     template='printSimParam.template',
                     extension='lua',
                     run_exec = False,
                     run_command = '',
                     depend = ['seeder','musubi'],
                     create_depend_path = True,
                     label = 'print'))

shepherd_jobs.append(dict(executable=apesFolder+'harvester/scripts/harvest_series.py',
                     template='params_hvs.py',
                     extension='py',
                     run_exec = run_hvs,
                     run_command = '',
                     input_option = '--config',
                     additional_params = dict(debug = 'false'), 
                     create_subdir = ['harvest'],
                     depend = ['musubi'],
                     label = 'hvs_sdr'))

shepherd_jobs.append(dict(executable=None,
                     template='horus.template',
                     extension='sh',
                     run_exec = submit_job,
                     run_command = 'sbatch',
                     params = [
                               ["nNodes", 12]
                              ],
                     create_dir = False,
                     create_depend_path = True,
                     depend = ['musubi'],
                     label = 'horus'))
######################################################################################

