require "common"
-- Location to write the mesh in.
-- Note the trailing path seperator, needed, if all mesh files should be in a
-- directory. This directory has to exist before running Seeder in this case!
folder = 'mesh/'

logging = {level=10}
NOdebug = {debugMode = true, debugFiles = false, debugMesh='debug/' }

-- bounding cube: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = origin_boundCube,
                length = length_bnd}

-- minimum refinement level in fluid domain
minlevel = level

spatial_object = {
  {
    attribute = {
      kind = 'seed',
      label='seed'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { 0.0, 0.0, 0.0 }
      }
    }
  },
  {
    -- Defining a domain boundary
    attribute = {
      kind = 'boundary', -- or seed, refinement
      label = 'nozzle',   -- some label to identify the boundary condition
      calc_dist = qVal,
      level = nozzleLevel,
      distance_refine = {
        {
          radius = inner_dia_nozzle,
          level_offset = 0
        },
        {
          radius = inner_dia_nozzle*2,
          level_offset = -1
        },
        {
          radius = inner_dia_nozzle*3,
          level_offset = -2
        }
      }
    },
    geometry = {
      kind = 'stl',
      object = {
--        {
--          filename = 'cylinder.stl'
--        },
        {
--          filename = 'nozzle.stl'
          filename = 'nozzle_asymmetric.stl'
        }
      }   
    }  
  },  

  {
    attribute = {
      kind = 'boundary',
      label = 'slip'
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = origin_inletBC,
          vec = { {l_ch+2*dx_eps,0.0,0.0},
                  {0.0,0.0,h_ch+2*dx_eps}}
        },          
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'outlet'
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = {origin_inletBC[1], h_ch/2.0+dx_eps, origin_inletBC[3]},
          vec = { {l_ch+2*dx_eps,0.0,0.0},
                  {0.0,0.0,h_ch+2*dx_eps}}
        },          
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'outlet'
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = origin_inletBC,
          vec = { {l_ch+2*dx_eps,0.0,0.0},
                  {0.0,h_ch+2*dx_eps,0.0}}
        },          
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'outlet'
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = {origin_inletBC[1], origin_inletBC[2], h_ch/2.0+dx_eps},
          vec = { {l_ch+2*dx_eps,0.0,0.0},
                  {0.0,h_ch+2*dx_eps,0.0}}
        },          
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'inlet'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = origin_inletBC, 
        vec = { {0.0,h_ch+2*dx_eps,0.0},
                {0.0,0.0,h_ch+2*dx_eps}}
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'outlet'
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = origin_outletBC,
          vec = { {0.0,h_ch+2*dx_eps,0.0},
                  {0.0,0.0,h_ch+2*dx_eps}}
        },
      }
    }
  },

}
