require "common"

simulation_name = 'nozzle'

variable = {
  {
    name = 'ref_pressure',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = p0_p
  },
  {
    name = 'normalized_pressure',
    ncomponents = 1,
    vartype = 'operation',
    operation = { 
      kind = 'difference',
      input_varname = {'pressure_phy','ref_pressure'}
    }
  },
  {
    name = 'cs_inv',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = cs_inv
  },
  {
    name = 'mach_nr',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'multiplication',
      input_varname = {'vel_mag', 'cs_inv'},
    }  
  }
}

-- define the input
restart = { 
  read = 'restart/nozzle_lastHeader.lua'
}

-- To dump all variable in binary file
--output_folder = 'vtkfiles/'
--output = { format = 'vtk'}

-- To dump specific variable
tracking = {
  {
    label = 'vtk', 
    folder = 'vtkfiles/',
    variable = {'normalized_pressure',
                'velocity_phy',
                'shear_stress_phy',
                'velocity',
                'mach_nr'
    }, 
    shape = {kind = 'all' },
    output = {format = 'vtk'}
  }
}
