gplfile='plot.gpl'
gplstatic='plot_static.gpl'
rm $gplfile
rm $gplstatic

nFiles=0
for file in `ls tracking/*.res`; do
  nFiles=$(expr $nFiles + 1)
done
echo found files $nFiles

counter=0
for file in `ls tracking/*.res`; do
  counter=$(expr $counter + 1)
  echo sorting $file
  sort -g $file -o $file
  # Write the animation gpl
  echo set title \"$file\" >> $gplfile
  echo "set yrange[ 0.999999: 1.0001]" >> $gplfile
  echo plot \"$file\" u 1:4 w l >> $gplfile
  echo pause 0.1 >> $gplfile
  # Write the static
  if [ $counter -eq 1 ]; then
    prefix='plot'
  else
    prefix=''
  fi
  if [ $counter -eq $nFiles ]; then
    suffix=''
  else
    suffix=',\\'
  fi
  echo $prefix \"$file\" u 1:4 w l $suffix >> $gplstatic
done
echo pause -1 >> $gplfile
echo pause -1 >> $gplstatic
