-- Musubi configuration file. 
-- This is a LUA script.

-- Simulation name
simulation_name = 'lidcavity'

-- Mesh information
mesh = 'mesh/'

interpolation_method = 'average'                     
-- Time step settings
tmax = 1000
sim_control = {
  time_control = {
    max = {iter = tmax},
      interval= {iter = tmax} 
    }
  } 
-- relaxation time Omega
-- Re = 100, omega = 1.625
-- Re = 400, omega = 1.891
-- Re = 1000, omega = 1.955
--scheme = {
rho0=1.
fluid = { omega = 1.891, rho0 = rho0 }
cs2 = 1./3.
p0 = rho0*cs2
--,
-- Initial condition 
initial_condition = { pressure  = p0, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }
--,
-- Boundary conditions
boundary_condition = {  
{ label = 'movingwall', 
  kind = 'inlet_ubb', 
  velocityX = 0.06, velocityY = 0.0, velocityZ = 0.0},
{ label = 'fixedwall', 
   kind = 'wall' 
   }
}
                     
-- Tracking              
tracking = { 
   label = 'probe_vel',
    folder = './',
    variable = {'velocity'}, 
    shape = {kind = 'canoND', object= { origin ={0., 0., 0.} } },
    time_control = {min= {iter = 0}, max ={iter = tmax}, interval ={iter = 10}},
    format = 'ascii' 
 }
--}

