mesh        = 'mesh/'
logging = {level=10}

-------------------------------------------------------------------------------
tmax        =  1000   
interval    =  100
sim_control = { 
  time_control     = { 
    min      = { iter = 0        },
    max      = { iter = tmax     },
    interval = { iter = interval } 
  }
}
-------------------------------------------------------------------------------
umax = 0.025

identify  = { label = 'fluid',  kind = 'lbm', relaxation = 'bgk', layout = 'd3q19' }
fluid     = { omega = 1.891,    rho0 = 1.0 }

initial_condition = { 
  pressure  = 1.0, 
  velocityX = 0.0,
  velocityY = 0.0,
  velocityZ = 0.0 
}

boundary_condition= {  
  { label     = 'west', 
    kind      = 'inlet_ubb', 
    velocity  = { predefined   = 'combined',
                  transient    = {
                    predefined = 'smooth', min_factor=0.0, max_factor=1.0, from_time = 0, to_time= 100
                 },
                 spatial      = { umax,0.0,0.0 },
                },
  },
  { label = 'east',  kind  = 'outlet_zero_prsgrd'}, 
  { label = 'north', kind  = 'wall' },
  { label = 'south', kind  = 'wall' },
  { label = 'top',   kind  = 'wall' },
  { label = 'bottom',kind  = 'wall' },
  { label = 'obst',  kind  = 'wall' }
}

-- Tracking              
tracking = {
  folder    = 'tracking/', 
  label     = 'vtk', 
  variable  = {'density', 'wss'}, 
  shape     = {
    kind   = 'all', 
  },
  output    = {format = 'vtk'},
  time_control = {min ={iter= tmax},max={iter=tmax},interval={iter=tmax}},
}
-------------------------------------------------------------------------------
variable = {
  {
    name       = 'wss_thres',
    ncomponents = 1,
    vartype     = 'st_fun',
    st_fun      = 0.000009
  },
  {
    name       = 'wss_cond',
    ncomponents = 1,
    vartype     = 'operation',
    operation   = {
      kind          = '<',
      input_varname = {'wss','wss_thres'}
    }
  }
}
-------------------------------------------------------------------------------
geomIncr = {solidify      = true,
            condition     = 'wss_cond',
            proximity     = true,
            time_control  = {
              min       = { iter=tmax/2},
              max       = { iter=tmax},
              interval  = { iter = 10 }
            }
}
-------------------------------------------------------------------------------
restart = {
  write = 'restart/',
  time_control = { 
    min      = { iter = tmax }, 
    max      = { iter = tmax }, 
    interval = { iter = tmax } 
  },
}
