import os
apesFolder = os.getenv('HOME')+'/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'prod'
loglevel = 'INFO'
shepherd_jobs = []

run_seeder = True
run_seeder = False

run_musubi = True
run_musubi = False

run_gleaner = True
run_gleaner = False

submit_job = True
submit_job = False

shepherd_jobs.append(dict(executable=apesFolder+'seeder/build/seeder',
                          template='seeder.template',
                          extension='lua',
                          run_exec = run_seeder,
                          run_command = '',
                          params = [['refineLevel', 0,1,2],
                  ],
                          additional_params = dict(dx_ref=0.41/8, height=0.41),
                          create_subdir = ['mesh'],
                          prefix = 'sdr',
                          label = 'seeder'))

shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                          template='musubi.template',
                          extension='lua',
                          run_exec = run_musubi,
                          run_command = 'mpirun -np 8',
			  params = [['outletBC', 'outlet_expol', 'outlet_expol_link']],
                          additional_params = dict(MESH='../mesh/', Re=20,omega=1.95, 
                                                   scaling = 'diffusive',
                                                   u_max_L=0.05),
                          create_subdir = ['tracking','restart'],
                          prefix = 'mus',
                          depend = ['seeder'],
                          create_depend_path = True,
                          label = 'musubi'))

shepherd_jobs.append(dict(executable=None,
                     template='printSimParam.template',
                     extension='lua',
                     run_exec = False,
                     run_command = '',
                     depend = ['seeder','musubi'],
                     create_depend_path = True,
                     label = 'print'))

shepherd_jobs.append(dict(executable=None,
                     template='horus.template',
                     extension='sh',
                     run_exec = submit_job,
                     run_command = 'sbatch',
                     params = [
                               ["nNodes", 2],
                               ["partition",'medium2'] 
                              ],
                     create_dir = False,
                     create_depend_path = True,
                     depend = ['musubi'],
                     label = 'horus'))

shepherd_jobs.append(dict(executable=apesFolder+'harvester/gleaner/gleaner.py',
                          template = 'plot_l2error.template',
                          extension='py',
                          run_exec = run_gleaner,
                          run_command = '',
                          depend = ['seeder','musubi'],
                          #depend = ['musubi'],
                          run_last = True,
                          create_depend_path = True,
                          create_depend_params = True,
                          label = 'gleaner'))

#shepherd_jobs.append(dict(executable=apesFolder+'harvester/gleaner/gleaner.py',
#                          template = 'params_plot_omega.py',
#                          extension='py',
#                          run_exec = run_gleaner,
#                          run_command = '',
#                          depend = ['seeder','musubi'],
#                          #depend = ['musubi'],
#                          run_last = True,
#                          create_depend_path = True,
#                          create_depend_params = True,
#                          label = 'gleaner'))
#
