import math
import glob
import numpy as np
from itertools import *

seeder_path = ['/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0']
infiles = ['/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega0.8_outletBCoutlet_expol', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega0.8_outletBCoutlet_pab', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega0.8_outletBCoutlet_nrbc', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega0.8_outletBCoutlet_dnt', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.1_outletBCoutlet_expol', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.1_outletBCoutlet_pab', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.1_outletBCoutlet_nrbc', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.1_outletBCoutlet_dnt', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.3_outletBCoutlet_expol', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.3_outletBCoutlet_pab', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.3_outletBCoutlet_nrbc', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.3_outletBCoutlet_dnt', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.5_outletBCoutlet_expol', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.5_outletBCoutlet_pab', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.5_outletBCoutlet_nrbc', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.5_outletBCoutlet_dnt', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.7_outletBCoutlet_expol', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.7_outletBCoutlet_pab', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.7_outletBCoutlet_nrbc', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.7_outletBCoutlet_dnt', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.8_outletBCoutlet_expol', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.8_outletBCoutlet_pab', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.8_outletBCoutlet_nrbc', '/home/UNISIEGEN/g013710/omega_study/convergence/sdr_refineLevel0/mus_omega1.8_outletBCoutlet_dnt']
omegas = [0.8, 1.1, 1.3, 1.5, 1.7, 1.8]
refineLevel = [0]
dx = 0.05125
height = 0.41
bc_type = ['outlet_expol', 'outlet_pab', 'outlet_nrbc', 'outlet_dnt']
params = [bc_type]

labels = []
filedict=dict()
filenames = []
for ipar in product(*params):
  pattern = str(ipar[0])
  filename = str(ipar[0])
  labels.append(str(ipar[0]))
  filenames.append(filename)
  for iFile in infiles:
    if pattern in iFile:
      #print (filename, iFile)
      if filename not in filedict:
        filedict[filename] = [iFile]
      else:
        filedict[filename].append(iFile)

def extractL2Norm(infiles, variable, fileprefix):
  filename = fileprefix+'_'+variable+"_l2Norm_omega.txt"
  filename2 = "'"+fileprefix+'_'+variable+"_l2Norm_omega.txt'"
  fileID = open(filename, "w")
  fileID.write("#omega \t difference_l2norm \t analy_l2norm \t rel_l2norm\n")
  for ifile in range(len(infiles)):  
    dataFile = glob.glob(infiles[ifile]+'/tracking/*'+variable+'_l2norm*.res')
    data = np.genfromtxt(dataFile[0], dtype = None)
    if data.size == data.shape[0]:
      data.resize(1,data.size)
    diff = data[-1,1]
    anal = data[-1,2]
    fileID.write(str(omegas[ifile])+'\t'+str(diff)+'\t'+str(anal)+'\t'+str(diff/anal)+'\n')  
    #print(data[-1,1],data[-1,2])

  fileID.close()
  return filename

vel_file = []
press_file = []
wss_file = []
for iFile in range(len(filenames)):
  # print (filenames[iFile], filedict[filenames[iFile]])
  vel_file.append(extractL2Norm(filedict[filenames[iFile]], 'vel', filenames[iFile]))
  press_file.append(extractL2Norm(filedict[filenames[iFile]], 'press', filenames[iFile]))
  wss_file.append(extractL2Norm(filedict[filenames[iFile]], 'wss', filenames[iFile]))

show_plot = True
markers = ['k-x','k-s','k-v','k-*','k-d','k-p']
plot  = []
font_size = 12
figsize=[5,4]
set_majorgrid = True
font_family = 'serif'
font_type = 'serif'

markers = ['r-o','b-','k--','k-*','k-v','kx','k-p','k-^','k+']

for iFile in range(len(filenames)):
  sPlot = False
  ePlot = False
  if iFile == 0:
    sPlot = True
  if iFile == (len(filenames)-1):
    ePlot = True

  plot.append(dict(kind = 'xy', 
              data=[vel_file[iFile]],
              col=[1,4],dtype='float', 
              startplot = sPlot, endplot = ePlot,
              xlabel = 'omega', 
              ylabel = 'Velocity relative l2norm error',
              label = labels[iFile], 
              ls = markers[iFile], 
              #xmin=10, xmax=1e4,
              #xlogscale = True, 
              ylogscale = True,
              legend=dict(loc=6),
              #label = '', ls = markers[ifile],
              #ls = '-o', 
              format = 'pdf', figname = 'Vel_relativeError_differentBC_omega', dpi=100 ))

for iFile in range(len(filenames)):
  sPlot = False
  ePlot = False
  if iFile == 0:
    sPlot = True
  if iFile == (len(filenames)-1):
    ePlot = True

  plot.append(dict(kind = 'xy', 
              data=[press_file[iFile]],
              col=[1,4],dtype='float', 
              startplot = sPlot, endplot = ePlot,
              xlabel = 'omega', 
              ylabel = 'Pressure relative l2norm error',
              label = labels[iFile], 
              ls = markers[iFile], 
              #xmin=10, xmax=1e4,
              legend=dict(loc=6),
              #xlogscale = True, 
              ylogscale = True,
              #label = '', ls = markers[ifile],
              #ls = '-o', 
              format = 'pdf', figname = 'press_relativeError_differentBC_omega', dpi=100 ))

for iFile in range(len(filenames)):
  sPlot = False
  ePlot = False
  if iFile == 0:
    sPlot = True
  if iFile == (len(filenames)-1):
    ePlot = True
  plot.append(dict(kind = 'xy', 
              data=[wss_file[iFile]],
              col=[1,4],dtype='float', 
              startplot = sPlot, endplot = ePlot,
              xlabel = 'omega', 
              ylabel = 'WSS relative l2norm error',
              label = labels[iFile], 
              ls = markers[iFile], 
              #xlogscale = True, 
              ylogscale = True,
              #xmin=10, xmax=1e4,
              legend=dict(loc=3),
              #label = '', ls = markers[ifile],
              #ls = '-o', 
              format = 'pdf', figname = 'wss_relativeError_differentBC_omega', dpi=100 ))

