require "common"

simulation_name = 'channel2D_Re'..Re
debug_mode = false

sim_control = {
  time_control = {
    max = {iter = tmax}, 
    interval = {iter = tmax/10}
  }
}
estart = {
  read = 'restart/'..simulation_name..'_lastHeader.lua',
  --write = 'restart/',
  --time = { interval  = 1, min = tmax, max = tmax,}
}

variable = {
  { name='vel_an', 
    ncomponents=1,
    vartype = 'st_fun',
    st_fun = velA },
  { name = 'wss_an', 
    ncomponents=1, 
    vartype = 'st_fun',
    st_fun = wssA },
  { name = 'diff_wss', 
    ncomponents = 1, 
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'wss_phy','wss_an'},
    }
  },
  { name = 'diff_vel', 
    ncomponents = 1, 
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'velMag_phy','vel_an'},
    }
  },
}

tracking = {
--{  label = 'pressureDrop_L'..level,
--  variable = {
--    { name = 'density', ncomponents = 1 }
--  },
--  shape = { kind = 'canoND', object = {origin = { -length/4, 0.0, dx/2 },
--                                       --vec = { length/2, 0.0, 0.0},
--                                       segments = {1} } },
--  time = { min = 1, max = tmax, interval = 10 },
--  folder = './tracking/',
--  format = 'ascii',}

{ label = 'wss_spatial_L'..level,
  variable = {
    'wss_phy',
    'wss_an',
    'diff_wss' },
  shape = { kind = 'canoND',
            object = {origin = { 0.0, -height/2, dx/2},
                      vec = { 0.0, height, 0.0},
                      segments = {200} }},
  time_control = { min = {iter = tmax}, max = {iter = tmax}, interval = {iter = 10} },
  folder = './tracking/',
  format = 'asciiSpatial',},

{ label = 'wss_l2norm_L'..level,
  variable = {
    'diff_wss', 
    'wss_an' },
  shape = { kind = 'canoND',
            object = {origin = { 0.0, -height/2, dx/2},
                      vec = { 0.0, height, 0.0},
                      segments = {100} }},
  time_control = { min = {iter = tmax}, max = {iter = tmax}, interval = {iter = 100} },
  reduction = {'l2norm', 'l2norm'},
  folder = './tracking/',
  format = 'asciiSpatial',},

{ label = 'vel_spatial_L'..level,
  variable = {
    'velMag',
    'velMag_phy',
    'vel_an',
    'diff_vel' },
  shape = { kind = 'canoND',
            object = {origin = { 0.0, -height/2, dx/2},
                      vec = { 0.0, height, 0.0},
                      segments = {200} }},
  time_control = { min = {iter = tmax}, max = {iter = tmax}, interval = {iter = 10} },
  folder = './tracking/',
  format = 'asciiSpatial',},

{ label = 'vel_l2norm_L'..level,
  variable = {
    'diff_vel',
    'vel_an'},
  shape = { kind = 'canoND',
            object = {origin = { 0.0, -height/2, dx/2},
                      vec = { 0.0, height, 0.0},
                      segments = {100} }},
  time_control = { min = {iter = tmax}, max = {iter = tmax}, interval = {iter = 100} },
  reduction = {'l2norm', 'l2norm'},
  folder = './tracking/',
  format = 'asciiSpatial',},
}   -- trakcing table

physics = { dt = dt, rho0 = denPhy, setPhysicalQuantities = true, }

initial_condition = { pressure = p0Phy, velocityX = 0, velocityY = 0, velocityZ = 0 }

identify = { label = '', kind = 'lbm', layout = 'd3q19'}

fluid = { omega = omega, rho0 = rho0 }

boundary_condition = {
  { label = 'outlet',  kind = 'outlet_expol',pressure = p0Phy, },
  { label = 'top', kind = 'wall'},
  { label = 'bottom', kind = 'wall'},
  { label = 'inlet', kind = 'outlet_expol', pressure = p0Phy + pDeltaPhy},
--  { label = 'inlet',   kind = 'inlet_ubb',
--  velocityX = {
--    predefined = 'combined',
--    transient= {
--      predefined='smooth',
--      min_factor=0.0, max_factor=velMax, from_time=0, to_time=tmax/4},
--    spatial = {
--      predefined='parabol',
--      shape = { kind = 'canoND', 
--                object = { origin = { -length/2+dx, -R*dx, dx/2},
--                           vec = { 0.0, 2*R*dx, 0.0 }
--                         }
--              } -- shape table
--              } -- spatial table
--              }, -- velX table
--  velocityY = 0.0,
--  velocityZ = 0.0,
--  }
} -- boundary condition
