require "common"

comment = '2d_channel'
minlevel = 1
folder = mesh -- mesh location spacified in common.lua

bounding_cube = { origin = {-length/2, -length/2, -length/2},
                  length = length }

spatial_object = {
  -- refine box should cover channel
  { attribute = { kind = 'refinement', level = level, },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { -length*0.5, -height*0.5, -dx/2 },
        vec = { { length,  0.0,  0.0 },
                { 0.0,  height,  0.0 },
                { 0.0,  0.0,  dx*2 },
        }
      } -- object
    }
  }, -- refinement
  { attribute = { kind = 'seed', },
    geometry = { kind = 'canoND',
                 object = { origin = { 0.0, 0.0, 0.0 },
               }
    }
  }, -- seed
  { attribute = { kind = 'periodic', label = 'periodic', level = level },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = { -length/2, -height/2-dx/2, -dx/2},
          vec = { { 0.0, height+dx, 0.0},
                  { length, 0.0, 0.0},}
        }, -- plane 1
        plane2 = {
          origin = { -length/2, -height/2-dx/2, dx+dx/2},
          vec = { { length, 0.0, 0.0},
                  { 0.0, height+dx, 0.0},}
        }, -- plane 2
      }
    }
  }, -- periodic table
  { attribute = { kind = 'boundary', label = 'top', level = level },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { -length/2, height/2+dx/2, -dx/2 },
        vec = { { length,0.0,0.0},
                { 0.0,0.0,height},
        }
      } -- object
    }
  }, -- top plane
  { attribute = { kind = 'boundary', label = 'bottom', level = level },
    geometry = {
      kind = 'canoND',
      object = {
        origin  = { -length/2, -height/2-dx/2, -dx/2 },
        vec = { { length,0.0,0.0},
                { 0.0,0.0,height},
        }
      } -- object
    }
  },-- bottom plane
  { attribute = { kind = 'boundary', label = 'outlet', level = level },
    geometry = {
      kind = 'canoND',
      object = {
        origin  = { length/2-dx/2, -height/2-dx/2, dx/2 },
        vec = { { 0.0, height+dx, 0.0},
                { 0.0, 0.0,       height},
        }
      } -- object
    }
  },-- right plane
  { attribute = { kind = 'boundary', label = 'inlet', level = level },
    geometry = {
      kind = 'canoND',
      object = {
        origin  = { -length/2+dx/2, -height/2-dx/2, dx/2 },
        vec = { { 0.0, height+dx, 0.0},
                { 0.0, 0.0,       height},
        }
      } -- object
    }
  }-- left plane
} -- spatial object
