require 'seeder'

simulation_name = 'lidcavity2D'
logging = {level=10}

-- define the input
restart = {
          read = 'restart/lidcavity_lastHeader.lua'
        }

-- Load output table if tracking table is not present
output_folder = 'harvest/'
output = { format = 'vtk' }

-- Tracking              
tracking_fol = 'harvest/'
tracking = {
  { 
    label = 'verticalLine_vel',
    folder = tracking_fol,
    variable = {'velocity'},
    shape = { kind = 'canoND', object = { 
                                 origin = { length/2.0,0.,0.0}, 
                                 vec = {0.,length,0.}, 
                                 segments=nLength+2}}, 
    output = {format='asciiSpatial'},
  },
  { 
    label = 'horizondalLine_vel',
    folder = tracking_fol,
    variable = {'velocity'},
    shape = { kind = 'canoND', object = { 
                                 origin = { 0.0,length/2.0,0.0}, 
                                 vec = {length,0.,0.0}, 
                                 segments=nLength+2}}, 
    output = {format='asciiSpatial'}, 
  },
  {
    label = 'hvs',
    folder = tracking_fol,
    variable = {'pressure','velocity','shear_stress'},
    shape = {kind='all'},
    output = {format='vtk'}
  },
}

