----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- Characteristic length of the domain
length = 1.0
nLength = 64
-- physical discretization step size
dx = length/nLength
nLength_bnd = nLength + 2
level = math.ceil(math.log(nLength_bnd)/math.log(2))
length_bnd = (2^level)*dx

-- seeder parameter
-- Maximum mesh refinement level
minlevel = level

-- mesh folder
folder = 'mesh/'
timing_file = 'sdr_timing.res'

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx, -dx, -dx},
               length = length_bnd
              }

spatial_object = {
  {
    attribute = { 
      kind = 'seed'
    },
    geometry = {
      kind = 'canoND',
      object = { origin = {length/2.0, length/2.0, dx/2.}}
    }
  },
  {
    attribute = { 
      kind = 'periodic'
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = { 
          origin = {-0.,-0.,dx+dx/2.0},
          vec = {{length+2*dx,0.0,0.0},
                 {0.0,length+2*dx,0.0}}
        },
        plane2 = {
          origin = {-0.,-0.,-dx/2.0},
          vec = {{0.0,length+2*dx,0.0},
                 {length+2*dx,0.0,0.0}}
        }
      }
    }
  },
  {
    attribute = { 
      kind = 'boundary',
      label = 'right'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length+2*dx-dx/1.0,-0.,-0.},
        vec = {{0.0,length+2*dx,0.0},
               {0.0,0.0,4*dx}}
      }
    }
  },
  {
    attribute = { 
      kind = 'boundary',
      label = 'left'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx/2.0,-0.,-0.},
        vec = {{0.0,length+2*dx,0.0},
               {0.0,0.0,4*dx}}
      }
    }
  },
  {
    attribute = { 
      kind = 'boundary',
      label = 'top'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {0.0,length+2*dx-dx/1.0,-0.},
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,4*dx}}
      }
    }
  },
  {
    attribute = { 
      kind = 'boundary',
      label = 'bottom'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {0.0,-dx/2.0,-0.},
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,4*dx}}
      }
    }
  },
}

