require 'common'

sim_control = {
  time_control = {
    max = tEnd,
    interval = tEnd / 10,
  },
}

physics = { dt = dt, rho0 = rhoPhy }

fluid = { 
  kine_shear_viscosity = nuPhy,
}

variable = {
{ name = 'coeff_fac', ncomponents = 3, vartype = 'st_fun', st_fun = {cD,cL,0} },
{ name = 'coeff',
  ncomponents = 3,
  vartype = 'operation',
  operation = {
    kind = 'multiplication',
    input_varname = { 'bnd_force_phy', 'coeff_fac' },
  },
},
{
  name = 'pOutlet',
  ncomponents = 1,
  vartype = 'st_fun',
  st_fun = pOutlet, 
},
{ name='vel_max',
  ncomponents=3,
  vartype = 'st_fun',
  st_fun  = { 1/velMaxPhy*dx*0.1, 1/velMaxPhy*dx*0.1, 1*0.1},
},
{ name='vel_norm',
  ncomponents=3,
  vartype = 'operation',
  operation = {
    kind = 'multiplication',
    input_varname = { 'velocity_phy', 'vel_max'},
  },
},
}

identify = {
  layout = layout,
  relaxation = relaxation,
  kind = kind,
}

initial_condition = {
  pressure  = p0,
  velocityX = 0.0,
  velocityY = 0.0,
  velocityZ = 0.0,
  Sxx = 0, Syy = 0, Szz = 0, Sxy = 0, Syz = 0, Sxz = 0,
}

boundary_condition = {
  { label = 'inlet',
    kind = inlet_kind,
    velocity = {
      predefined = 'combined',
      temporal  = {
        predefined = 'smooth',
        min_factor = 0, max_factor = 1.0,
        from_time = 0, to_time = tRamp
      },
      NOspatial = {Um,0.0,0.0},
      spatial = {
        predefined = 'parabol',
        shape = {
          kind = 'canoND',
          object = {
            origin = { inlet_x, bottom_y-dx/2, zpos},
            vec    = {     0.0, top_y - bottom_y + dx , 0.0 },
          },
        }, -- shape table
        amplitude = {Um,0.0,0.0},
      } -- spatial table
    }  

  },
  { label = 'outlet',
     kind = outlet_kind,
     pressure = pOutlet
  },
  { label = 'top',
    --kind  = 'symmetry',
    kind  = 'wall',
  },
  { label = 'bottom',
    --kind  = 'symmetry',
    kind  = 'wall',
  },
  { label = 'cylinder',
    kind  = bc_wall,
  },
}

tracking = {

  -- global flow domain
--  { label = 'global',
--    folder = 'tracking/',
--    variable = {
--      'pressure_phy',
--      'velocity_phy',
--      'wss_phy',
--      -- 'treeID',
--    },
--    shape = { kind = 'all', },
--    time_control = {
--      min = 0, 
--      max = tEnd, 
--      interval = tEnd/50
--    },
--    output = { format = 'vtk' },
--  }, -- tracking global
  -- force on cylinder
  { label = 'force_on_cylinder',
    folder = 'tracking/',
    variable = {
      'coeff',
      -- 'bnd_force_phy',
    },
    shape = {
      kind = 'boundary',
      boundary = { 'cylinder' },
    },
    time_control = { 
      min = tEnd-2, 
      max = tEnd, 
      interval = 0.05, 
    },
    reduction = { 'sum' },
    output = { format = 'ascii' },
  }, -- tracking force on cylinder
  -- global flow domain in ascii-spatial format for every 10 iteration
  -- to create animation using python script
--  { label = 'vel_global',
--    folder = 'tracking/',
--    variable = { 'vel_norm' },
--    shape = { kind = 'global' },
--    time_control = { 
--      min = 0, 
--      max = tEnd, 
--      interval = { iter = 10 }, 
--    },
--    output = { format = 'asciiSpatial' },
--  },
  { label = 'pressureDrop',
    variable = {
      'pressure_phy',
      'velocity_phy',
    },
    shape = {
      kind = 'canoND',
      object = {
        origin = { inlet_x, 0.0, dx/2 },
        vec = { L, 0.0, 0.0},
        segments = {200},
      },
    }, -- shape
    time_control = { 
      --min = tEnd, 
      --max = tEnd, 
      min = {iter=tEnd},
      max = {iter=tEnd},
      interval = {iter=1}
    },
    folder = './tracking/',
    output = { format = 'asciiSpatial', },
  },

  { label = 'strainRate_spatial',
    variable = {
      'strain_rate_phy',
    },
    shape = { 
      kind = 'canoND',
      object = {
        origin = { 0.0, -H/2, dx/2},
        vec = { 0.0, H, 0.0},
        segments = {200} 
      }
    },
    time_control = {
      --min = tEnd,
      --max = tEnd,
      min = {iter=tEnd},
      max = {iter=tEnd},
      interval = {iter=1}
    },
    folder = './tracking/',
    output = { format = 'asciiSpatial', },
  },

  { label = 'wss_spatial',
    variable = {
      'wss_phy',
    },
    shape = {
      kind = 'canoND',
      object = {
        origin = { 0.0, -H/2, dx/2},
        vec = { 0.0, H, 0.0},
        segments = {200}
      }
    },
    time_control = {
      --min = tEnd,
      --max = tEnd,
      min = {iter=tEnd},
      max = {iter=tEnd},
      interval = {iter=1},
    },
    folder = './tracking/',
    output = { format = 'asciiSpatial', },
  },
  
  
  { label = 'vel_spatial',
    variable = {
      'vel_mag_phy',
      'vel_mag',
    },
    shape = { 
      kind = 'canoND',
      object = {
        origin = { 0.0, -H/2, dx/2},
        vec = { 0.0, H, 0.0},
        segments = {200} 
      }
    },
    time_control = { 
      --min = tEnd, 
      --max = tEnd, 
      min = {iter=tEnd},
      max = {iter=tEnd},
      interval = {iter=1} 
    },
    folder = './tracking/',
    output = { format = 'asciiSpatial', },
  },
  
  -- vel and pressure at inlet
  { label = 'inlet_spatial',
    variable = {
      'velocity_phy','pressure_phy','strain_rate_phy',},
    shape = {
      kind = 'canoND',
      object = {
        origin = { inlet_x+(3./2.)*dx, -H/2, dx/2},
        vec = { 0.0, H, 0.0}, segments = {100}
      }
    },
    time_control = {
      --min = tEnd,
      --max = tEnd,
      min = {iter=tEnd},
      max = {iter=tEnd},
      interval = { iter = 1 },
    },
    folder = './tracking/',
    output = { format = 'asciiSpatial', },
  },
  -- vel and pressure at outlet
  { label = 'outlet_spatial',
    variable = {
      'velocity_phy', 'pressure_phy','strain_rate_phy' },
    shape = {
      kind = 'canoND',
      object = {
        origin = { outlet_x-(3./2.)*dx, -H/2, dx/2},
        vec = { 0.0, H, 0.0}, segments = {100}
      },
    },
    time_control = {
      --min = tEnd,
      --max = tEnd,
      min = {iter=tEnd},
      max = {iter=tEnd},
      interval = { iter = 1 },
    },
    folder = './tracking/',
    output = { format = 'asciiSpatial', },
  },

} -- tracking
