require 'common'

shepherd = true
if shepherd then
  stlFolder = '$!stl_path!$'
else
  stlFolder = '../'
end
timing_file = 'sdr_timing.res'

bounding_cube = {
  origin = { inlet_x - dx_half, bottom_y - dx_half, -dx },
  length = bounding_length,
}

minlevel = level

logging = { level = 1 }

spatial_object = {
  {
    attribute = { kind = 'seed', },
    geometry = {
      kind = 'canoND',
      object = { origin = { 2*D, 0.0, zpos }, }
    }
  }, -- seed

  {
    attribute = {
      kind = 'boundary',
      label = 'top',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { inlet_x, top_y, -dx_half },
        vec = {
          { outlet_x - inlet_x, 0.0,    0.0 },
          {                0.0, 0.0, dx * 2 },
        }
      }
    },
  }, -- top

  {
    attribute = {
      kind = 'boundary',
      label = 'bottom',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { inlet_x, bottom_y, -dx_half },
        vec = {
          { outlet_x - inlet_x, 0.0,    0.0 },
          {                0.0, 0.0, dx * 2 },
        }
      }
    },
  }, -- bottom

  {
    attribute = {
      kind = 'boundary',
      label = 'inlet',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { inlet_x, bottom_y, -dx_half },
        vec = {
          { 0.0, top_y - bottom_y,    0.0 },
          { 0.0,              0.0, dx * 2 },
        }
      }
    },
  }, -- inlet

  {
    attribute = {
      kind = 'boundary',
      label = 'outlet',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { outlet_x, bottom_y, -dx_half },
        vec = {
          { 0.0, top_y - bottom_y,    0.0 },
          { 0.0,              0.0, dx * 2 },
        }
      }
    },
  }, -- outlet

  {
    attribute = {
      kind  = 'boundary',
      label = 'z',
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = { inlet_x, bottom_y, periodic_z1 },
          vec = {
            {                0.0, top_y - bottom_y, 0.0 },
            { outlet_x - inlet_x,              0.0, 0.0 },
          },
        },
        {
          origin = { inlet_x, bottom_y, periodic_z2 },
          vec = {
            { outlet_x - inlet_x,              0.0, 0.0 },
            {                0.0, top_y - bottom_y, 0.0 },
          },
        },
      }, -- object
    }, -- geometry
  }, -- z planes

  {
    attribute = {
      kind = 'boundary',
      label = 'cylinder',
      calc_dist = qValue,
      flood_diagonal = flood_diagonal,
    },
    geometry = {
      kind = 'stl',
      format = 'binary',
      object = {
        filename = stlFolder..'cylinder.stl',
      }
    },
    transformation = {
      deformation =  {          R,          R, R },
      translation =  { cylinder_x, cylinder_y, 0 },
    },
  },  -- cylinder
}
