----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = false
comm_reduced = false
bc_inlet = 'spc_molefrac'
bc_outlet = 'spc_outlet_vel'
bc_outlet = 'moments_vel'

if bc_type == 'moments' then
  --bc_inlet = 'spc_moments_moleflux'
  --bc_outlet = 'spc_moments_outflow'
  bc_inlet = 'spc_moments_molefrac'
  bc_outlet = 'spc_moments_vel'
  bc_wall_north = 'spc_moments_wall'
  bc_wall_south = 'spc_moments_wall'
end  
if bc_type == 'moments_BB' then
  --bc_inlet = 'spc_moments_molefrac'
  --bc_outlet = 'spc_moments_vel'

  bc_inlet = 'spc_molefrac'
  bc_outlet = 'spc_bb_vel'

  --bc_inlet = 'spc_bb_wall'
  --bc_outlet = 'spc_bb_wall'
  bc_wall_north = 'spc_bb_wall'
  bc_wall_south = 'spc_bb_wall'
  --bc_inlet = 'wall'
  --bc_outlet = 'wall'
  --bc_wall = 'wall'
  --bc_wall = 'wall'
end  

if bc_type == 'wall' then
  bc_inlet = 'spc_moments_wall'
  bc_outlet = 'spc_moments_wall'
  bc_wall_north = 'spc_moments_wall'
  bc_wall_south = 'spc_moments_wall'
end  
if bc_type == 'BounceBack' then
  bc_inlet = 'spc_molefrac_eq'
  --bc_inlet = 'spc_moleflux'
  --bc_inlet = 'spc_inlet_eq'
  bc_outlet = 'spc_vel_bb'
  --bc_outlet = 'spc_moleflux'
  --bc_outlet = 'spc_outlet_expol'
  bc_wall_north = 'spc_slip_wall'
  bc_wall_south = 'wall'
end

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'taylorDispersion'
mesh = 'mesh/'
--mesh = { predefined='cube', 
--         origin = {0.,0.,0.}, 
--         length = length, 
--         refinementLevel = level }

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   
scaling = 'diffusive'

ebug = {logging = {level=10, filename = 'dbg_bgk.out', root_only=false},
         debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}
logging = {level=1}

-- Time step settings
interval_p = tmax_p/100
tmax = 10000 --tmax_p/dt
interval = 1000
sim_control = {
  time_control = {
    min = 0 ,
    max = {sim=tmax_p,iter=tmax},
    interval = {sim=interval_p,iter=interval} 
  }
}


-- restart
restart = {
      --read = 'restart/taylorDispersion_lastHeader.lua',
      --read = 'restart/taylorDispersion_header_15.000E+00.lua',
      write = 'restart/',
      --time_control = { min = 0, max = tmax_p, interval = {iter=interval}}
      ime_control = {
        min = 0 ,
        max = {sim=tmax_p,iter=tmax},
        interval = {sim=interval_p,iter=interval} 
      }
}

physics = { rho0 = rho0, 
            dt = dt, 
            moleDens0=1000.0,
            --molWeight0 = m_min 
          }

-- scheme model for single fluid simulation
scheme = {
  identify = {
      label = 'mix',
      kind = 'multi-species_liquid', 
      relaxation = 'bgk', 
      --relaxation = 'mrt', 
-- scheme layout
      --layout = 'd3q19'
      layout = 'd2q9'
  },

  mixture = { rho0 = rho0, moleDens0 = 1000.0,
              omega_diff = omega_diff,
              --paramB = 0.01,
              --kine_shear_viscosity = nu,
              omega_kine = 2.0,
              --bulk_viscosity = nu,
              theta_eq = 1.0,
              initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
            },

 -- user variables
 variable = {
   {
     name = 'BC_velocity',
     ncomponents = 1,
     vartype = 'st_fun',
     st_fun = BC_velocity
   },
   {
     name = 'vel_zero',
     ncomponents = 1,
     vartype = 'st_fun',
     st_fun = 0.0
   },
   {
     name = 'bc_vel',
     ncomponents = 3,
     vartype = 'operation',
     operation = {
       kind = 'combine',
       input_varname = {'BC_velocity','vel_zero','vel_zero'}
     }  
   },
   { 
     name = 'mf_inlet_H2O',
     ncomponents = 1,
     vartype = 'st_fun',
     st_fun = BC_H2O 
   },
   { 
     name = 'mf_inlet_Na',
     ncomponents = 1,
     vartype = 'st_fun',
     st_fun = BC_Na 
   },
   { 
     name = 'outlet_press',
     ncomponents = 1,
     vartype = 'st_fun',
     st_fun = 0.0 
   },
   { 
     name = 'moleflux_H2O',
     ncomponents = 3,
     vartype = 'st_fun',
     st_fun = moleflux_H2O
   },
   { 
     name = 'moleflux_Na',
     ncomponents = 3,
     vartype = 'st_fun',
     st_fun = moleflux_Na
   },
 },

  -- field which defines fluid or specie
  -- Single fluid simulation
  field = {{
    label = 'H2O'
-- species properties
   ,species = { molweight = mH2O, 
                diff_coeff = { diff_diag, diff_H2O_Na } }
-- Initial condition
   ,initial_condition = { 
      mole_fraction = IC_H2O,
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'west',
       kind = bc_inlet,
       mole_fraction = 'mf_inlet_H2O',
       velocity = 'bc_vel',
       mole_flux = 'moleflux_H2O'
     },
     {
       label = 'east',
       kind = bc_outlet,
       mole_fraction = 'mf_inlet_H2O',
       velocity = 'bc_vel',
       mole_flux = 'moleflux_H2O',
       pressure = 'outlet_press'
     },
     { label = 'north', kind = bc_wall_north},
     { label = 'south', kind = bc_wall_south}
    }
  }
 ,{
    label = 'Na'
   ,species = { molweight = mNa, 
                diff_coeff = { diff_H2O_Na, diff_diag } }
   ,initial_condition = {
      mole_fraction = IC_Na,
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'west',
       kind = bc_inlet,
       mole_fraction = 'mf_inlet_Na',
       velocity = 'bc_vel',
       moleflux = 'moleflux_Na'
     },
     {
       label = 'east',
       kind = bc_outlet,
       mole_fraction = 'mf_inlet_Na',
       velocity = 'bc_vel',
       moleflux = 'moleflux_Na',
       pressure = 'outlet_press'
     },
     { label = 'north', kind = bc_wall_north},
     { label = 'south', kind = bc_wall_south}
    }
  }
  }

, 
tracking = {
--  {
--   label = 'inlet', 
--   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={dx/2.,0.0,zpos},
--                                      vec={0.0,height,0.0},
--                                      segments =nHeight+2 }
--           },
--   format = 'asciiSpatial',
--   time = {min = 0, max = tmax_p, interval = tmax_p}, 
--   ime = {min = 0, max = tmax, interval = 1}, 
--  },
--  {
--   label = 'hvs', 
--   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'},
--               {'H2O_mole_density_phy'},{'Na_mole_density_phy'},{'mole_density_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={0.0,0.0,zpos},
--                                      vec={{length,0.0,0.0},{0.0,height,0.0}},
--                                      segments ={nLength+2,nHeight+2} }
--           },
--   output = {format = 'harvester'},
--   time_control = {min = 0, max = tmax_p, interval = tmax_p/10}, 
--   ime_control = {min = 0, max = tmax, interval = 1}, 
--  },
  {
   label = 'numDensity', 
   variable = {'H2O_mole_density_phy','Na_mole_density_phy','mole_density_phy'},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={0.0,height/2.0,zpos},
                                      vec={length,0.0,0.0},
                                      segments =nLength+2 }
           },
   output = {format = 'asciispatial'},
   time_control = {min = dt*tmax, max = dt*tmax, interval = dt*tmax}, 
  },
  {
   label = 'molefraction', 
   variable = {'H2O_mole_fraction','Na_mole_fraction','mole_fraction'},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={0.0,height/2.0,zpos},
                                      vec={length,0.0,0.0},
                                      segments =nLength+2 }
           },
   output = {format = 'asciispatial'},
   time_control = {min = dt*tmax, max = dt*tmax, interval = dt*tmax}, 
  },

--  {
--   label = 'velocity', 
--   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={0.0,height/2.0,zpos},
--                                      vec={length,0.0,0.0},
--                                      segments =nLength+2 }
--           },
--   format = 'asciiSpatial',
--   time = {min = 0, max = tmax_p, interval = tmax_p/10}, 
--   ime = {min = 0, max = tmax, interval = 1}, 
--  },

--  {
--   label = 'point', 
--   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'},
--               {'H2O_mole_density_phy'},{'Na_mole_density_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={length/2.,height/2.,zpos} } },
--   format = 'ascii',
--   time = {min = 0, max = tmax_p, interval = dt*10}, 
--  }
  }
}


