----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"
scheme_kind = 'bgk'
tracking_fol = './'

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true
control_routine = 'fast'
-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'diluteWithForce'
mesh = 'mesh/'
--mesh = { predefined='cube', 
--         origin = {0.,0.,0.}, 
--         length = length, 
--         refinementLevel = level }

scaling = 'diffusive'

logging = {level=10}
ebug = {logging = {level=1, filename = 'dbgOut'},
         debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
interval = tmax_p/20
sim_control = {
  time_control = {
    max = {sim=tmax_p}, 
    interval = interval
  }
}  

physics = { rho0 = rho0, 
            dt = dt, 
            --molWeigh0 = m_min,
            moleDens0 = 1000.0,
            temp0 = 273.0,
            coulomb0 = 1.60217660e-19
}

-- scheme model for single fluid simulation
identify = {
    kind = 'multi-species_liquid', 
    relaxation = scheme_kind, 
    --relaxation = 'mrt', 
-- scheme layout
    layout = 'd3q19'
    --layout = 'd2q9'
}

-- replaced by sources.
-- electric field to all species is
-- applied via glob_source
-- external_force = { electric_fieldX = 1e-3,
--                     electric_fieldY = 0.0,
--                     electric_fieldZ = 0.0 },

glob_source = { 
  electric_field = 'electric'
}

mixture = { rho0 = rho0, moleDens0 = 1000.0, 
            omega_diff = 2.0,
            --kine_shear_viscosity = nu_p,
            --omega_kine = 2.0,
            temp = 293.15,
            electricField = { 1e-3, 0.0, 0.0},
            gravityField = { 0.0,0.0,0.0},
            theta_eq = 0.0,
            initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
          }
  -- field which defines fluid or specie
  -- Single fluid simulation
field = {{
    label = 'H2O'
-- species properties
   ,species = { molweight = mH2O, 
                diff_coeff = { diff_diag, diff_H2O_Na, diff_H2O_Cl},
                charge_nr = charge_nr_H2O}
-- Initial condition
   ,initial_condition = { 
       mole_fraction = diluteH2O,
       velocityX = 0.0,
       velocityY = 0.0,
       velocityZ = 0.0}
   }
 ,{
   label = 'Na'
  ,species = { molweight = mNa, 
               diff_coeff = { diff_H2O_Na, diff_diag, diff_Na_Cl },
               charge_nr = charge_nr_Na}
  ,initial_condition = {
       mole_fraction = diluteNa,
       velocityX = 0.0,
       velocityY = 0.0,
       velocityZ = 0.0}
  }
 ,{
   label = 'Cl'
  ,species = { molweight = mCl, 
               diff_coeff = { diff_H2O_Cl, diff_Na_Cl, diff_diag },
               charge_nr = charge_nr_Cl}
  ,initial_condition = {
       mole_fraction = diluteCl,
       velocityX = 0.0,
       velocityY = 0.0,
       velocityZ = 0.0}
  }
}

variable = {
  { name = 'electric',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun = {1e-3,0.0,0.0}
  }
}
 
tracking = {
  {
   label = 'point', 
   variable = {'H2O_mole_density_phy','Na_mole_density_phy','Cl_mole_density_phy',
               'density_phy','mole_density_phy','velocity_phy',
               'H2O_mole_fraction','Na_mole_fraction','Cl_mole_fraction','mole_fraction'},
   folder = tracking_fol,
   shape = {kind = 'canoND', object= {origin={0.130900,0.130900,dx/2}}},
   output={format = 'ascii'},
   time_control = {min = 0, max = tmax_p, interval = dt}, 
  }
--  ,{
--   label = 'line', 
--   variable = {{'H2O_molefrac'},{'Na_molefrac'},{'Cl_molefrac'},{'molefrac'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={0.0,dx/2.0,dx/2},
--                                      vec = {length, 0.0,0.0},
--                                      segments = nLength+2}},
--   output={format = 'asciiSpatial'},
--   time_control = {min = 0, max = tmax_p, interval = tmax_p}, 
--  }

}
