----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = false
comm_reduced = true
bc_inlet = 'spc_molefrac'
bc_outlet = 'spc_outlet_vel'
bc_outlet = 'moments_vel'

if bc_type == 'moments' then
  bc_inlet = 'spc_moments_molefrac'
  bc_outlet = 'spc_moments_vel'
  bc_wall = 'spc_moments_wall'
end  

if bc_type == 'BounceBack' then
  bc_inlet = 'spc_molefrac'
  bc_outlet = 'spc_vel_bb'
  bc_wall = 'wall'
end

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'channel2D'
mesh = 'mesh/'

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   
scaling = 'diffusive'

ebug = {logging = {level=1, filename = 'dbg_bgk.out', root_only=false},
         debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
tmax_p = 10 --s
interval_p = tmax_p/10
tmax = tmax_p/dt
interval = 1000
sim_control = {
  time_control = {
    min = 0 ,
    max = {sim=tmax_p,iter=tmax},
    interval = {sim=interval_p,iter=interval} 
  },
  abort_criteria = {
    stop_file = 'stop',
    steady_state = true
    convergence = {
      variable = {'vel_mag_phy'}, 
      shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos},
                                         vec = {0.0,height,0.0},
                                         segments = nHeight+2} },
      time_control = {min = 0, max = tmax_p, interval = 10*dt},
      reduction = 'average',
      norm='average', nvals = 50, absolute = true,
      condition = { threshold = 1.e-8, operator = '<=' }
    }
  }
}


-- restart
restart = {
      --read = 'restart/taylorDispersion_lastHeader.lua',
      write = 'restart/',
      --time_control = { min = 0, max = tmax_p, interval = {iter=interval}}
      time_control = {
        min = 0 ,
        max = {sim=tmax_p,iter=tmax},
        interval = {sim=interval_p,iter=interval} 
      }
}

physics = { 
            dt = dt, 
            moleDens0=1000.0,
            molWeight0 = m_min 
          }

-- scheme model for single fluid simulation
scheme = {
  identify = {
      label = 'mix',
      kind = 'multi-species_liquid', 
      relaxation = 'bgk', 
      --relaxation = 'mrt', 
-- scheme layout
      layout = 'd3q19'
  },

  mixture = { rho0 = rho0, moleDens0 = 1000.0,
              omega_diff = omega_diff,
              --paramB = 0.01,
              --kine_shear_viscosity = nu,
              omega_kine = 2.0,
              --bulk_viscosity = nu,
              theta_eq = 1.0,
              initial_condition = { pressure = 0.0} 
            },

  -- user variables
  variable = {
    {
      name = 'mf_inlet_H2O',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = 0.5
    },
    {
      name = 'mf_inlet_Na',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = 0.5
    },
    {
      name = 'vel_x',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = u_inflow
    },
    {
      name = 'vel_zero',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = 0.0
    },
    {
      name = 'bc_vel',
      ncomponents = 3,
      vartype = 'operation',
      operation = {
        kind = 'combine',
        input_varname = {'vel_x', 'vel_zero', 'vel_zero'}
      }
    },
    { name='vel_an', 
      ncomponents=1, 
      vartype = 'st_fun',
      st_fun=u_inflow 
    },
    { name = 'vel_diff',
      ncomponents = 1,
      vartype = 'operation',
      operation = {
        kind = 'difference',
        input_varname = {'vel_mag_phy', 'vel_an'}
      }
    }  
  },

  -- field which defines fluid or specie
  -- Single fluid simulation
  field = {{
    label = 'H2O'
-- species properties
   ,species = { molweight = mH2O, 
                diff_coeff = { diff_diag, diff_H2O_Na } }
-- Initial condition
   ,initial_condition = { 
      mole_fraction = 0.5,
      velocityX = u_inflow, 
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'west',
       kind = bc_inlet,
       mole_fraction = 'mf_inlet_H2O',
     },
     {
       label = 'east',
       kind = bc_outlet,
       velocity = 'bc_vel',
     },
     { label = 'north', kind = bc_wall},
     { label = 'south', kind = bc_wall}
    }
  }
 ,{
    label = 'Na'
   ,species = { molweight = mNa, 
                diff_coeff = { diff_H2O_Na, diff_diag } }
   ,initial_condition = {
      mole_fraction = 0.5,
      velocityX = u_inflow,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'west',
       kind = bc_inlet,
       mole_fraction = 'mf_inlet_Na',
     },
     {
       label = 'east',
       kind = bc_outlet,
       velocity = 'bc_vel',
     },
     { label = 'north', kind = bc_wall},
     { label = 'south', kind = bc_wall}
    }
  }
  }
, 
-- Tracking              
tracking = {
{
  label = 'probe', 
  folder = 'tracking/',
  variable = {'velocity_phy'}, 
  shape = {kind = 'canoND', object = {origin ={length*0.5,height*0.5-offset,zpos} } },
  time_control = {min= {iter= 1}, max = {iter= tmax}, interval = {iter= 10}},
  output = {format = 'ascii'}      
},
{
  label = 'velProfile', 
  folder = 'tracking/',
  variable = {'velocity_phy'}, 
  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos},
                                      vec = {0.0,height,0.0},
                                      segments = nHeight+2} },
  time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
  output = {format = 'asciiSpatial'}
},
{ label = 'vel_spatial',
  variable = {
    'vel_mag_phy', 'vel_an', 'vel_diff'
  },
  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos},
                                       vec = { 0.0, height, 0.0},
                                       segments = {nHeight+2} 
                              }
  },
  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
  folder = './tracking/',
  output = {format = 'asciiSpatial'},
},
{ label = 'vel_l2norm',
  variable = { 'vel_diff', 'vel_an'}
  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos},
                                       vec = { 0.0, height, 0.0},
                                       segments = {nHeight+2} 
                              }
  },
  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
  reduction = {'l2norm', 'l2norm'},
  folder = './tracking/',
  output = {format = 'asciiSpatial'}
}
}
}


