import math
import glob
import numpy as np
from itertools import *

seeder_path = $!seeder_path!$
infiles = $!musubi_path!$
omegas = $!musubi_omega!$
nHeight = $!seeder_nHeight!$
bc_type = $!seeder_bc_type!$
params = [bc_type,omegas]

labels = []
#pattern=[]
filedict=dict()
filenames = []
for ipar in product(*params):
  pattern = str(ipar[0])+'/mus_omega'+str(ipar[1])
  filename = str(ipar[0])+'_mus_omega'+str(ipar[1])
  #labels.append('bc\_type = '+str(ipar[0])+', omega = '+str(ipar[1]))
  labels.append('bc\_type='+str(ipar[0]))
  filenames.append(filename)
  for iFile in infiles:
    if pattern in iFile:
      #print (filename, iFile)
      if filename not in filedict:
        filedict[filename] = [iFile]
      else:
        filedict[filename].append(iFile)
      #  filenames.append(str(ipar[0])+'_mus_omega'+str(ipar[1]))

#print (filedict[filenames[0]])
#print (pattern)
#print (filenames)
#print (infiles[0])
#print ('moments/mus_omega0.8' in infiles[0])
#
show_plot = False
markers = ['k-x','k-s','k-v','k-*','k-d','k-p']
plot  = []
font_size = 12
figsize=[5,4]
set_majorgrid = True
#font_family = 'sans_serif'
#font_type = 'sans_serif'

markers = ['r-','b--','kx','k-*','k-v','kx','k-p','k-^','k+']

for iFile in range(len(filenames)):
  sPlot = False
  ePlot = False
  if iFile == 0:
    sPlot = True
  if iFile == (len(filenames)-1):
    ePlot = True

  plot.append(dict(kind = 'xy', 
              data=[filedict[filenames[iFile]][0]+'/tracking/*vel_spatial*.res'],
              row=[1,-1], col=[2,4],dtype='float', 
              startplot = sPlot, #endplot = ePlot,
              xlabel = 'y (m)', 
              ylabel = 'Velocity (m/s)',
              label = labels[iFile], ls = markers[iFile], 
              #xlogscale = True, ylogscale = True,
              #label = '', ls = markers[ifile],
              #ls = '-o', 
              format = 'pdf', figname = 'Velocity_Profile_differentBC', dpi=100 ))

  if ePlot == True:
    plot.append(dict(kind = 'xy', 
                data=[filedict[filenames[0]][0]+'/tracking/*vel_spatial*.res'],
                row=[1,-1], col=[2,5],dtype='float', 
                startplot = sPlot, endplot = ePlot,
                xlabel = 'y (m)', 
                ylabel = 'Velocity (m/s)',
                #xmin = 0.0, xmax=0.4,
                label = 'Analytic', ls = markers[iFile+1], 
                legend=dict(loc=8),
                #xlogscale = True, ylogscale = True,
                #label = '', ls = markers[ifile],
                #ls = '-o', 
                format = 'pdf', figname = 'Velocity_Profile_differentBC', dpi=100 ))

for iFile in range(len(filenames)):
  sPlot = False
  ePlot = False
  if iFile == 0:
    sPlot = True
  if iFile == (len(filenames)-1):
    ePlot = True

  plot.append(dict(kind = 'xy', 
              data=[filedict[filenames[iFile]][0]+'/tracking/*press_line*.res'],
              row=[1,-1], col=[1,4],dtype='float', 
              startplot = sPlot, #endplot = ePlot,
              xlabel = 'x (m)', 
              ylabel = 'Pressure (Pa)',
              label = labels[iFile], ls = markers[iFile], 
              #xlogscale = True, ylogscale = True,
              #label = '', ls = markers[ifile],
              #ls = '-o', 
              format = 'pdf', figname = 'Pressure_Profile_differentBC', dpi=100 ))

  if ePlot == True:
    plot.append(dict(kind = 'xy', 
                data=[filedict[filenames[0]][0]+'/tracking/*press_line*.res'],
                row=[1,-1], col=[1,5],dtype='float', 
                startplot = sPlot, endplot = ePlot,
                xlabel = 'x (m)', 
                ylabel = 'Pressure (Pa)',
                label = 'Analytic', ls = markers[iFile+1], 
                #xmin = 0.0, xmax=0.4,
                #xlogscale = True, ylogscale = True,
                #label = '', ls = markers[ifile],
                #ls = '-o', 
                format = 'pdf', figname = 'Pressure_Profile_differentBC', dpi=100 ))

for iFile in range(len(filenames)):
  sPlot = False
  ePlot = False
  if iFile == 0:
    sPlot = True
  if iFile == (len(filenames)-1):
    ePlot = True

  plot.append(dict(kind = 'xy', 
              data=[filedict[filenames[iFile]][0]+'/tracking/*wss_spatial*.res'],
              row=[1,-1], col=[2,4],dtype='float', 
              startplot = sPlot, #endplot = ePlot,
              xlabel = 'y (m)', 
              ylabel = 'WSS (Pa)',
              label = labels[iFile], ls = markers[iFile], 
              #xlogscale = True, ylogscale = True,
              #label = '', ls = markers[ifile],
              #ls = '-o', 
              format = 'pdf', figname = 'WSS_Profile_differentBC', dpi=100 ))

  if ePlot == True:
    plot.append(dict(kind = 'xy', 
                data=[filedict[filenames[0]][0]+'/tracking/*wss_spatial*.res'],
                row=[1,-1], col=[2,5],dtype='float', 
                startplot = sPlot, endplot = ePlot,
                xlabel = 'y (m)', 
                ylabel = 'WSS (Pa)',
                #xmin = 0.0, xmax=0.4,
                legend=dict(loc=9),
                label = 'Analytic', ls = markers[iFile+1], 
                #xlogscale = True, ylogscale = True,
                #label = '', ls = markers[ifile],
                #ls = '-o', 
                format = 'pdf', figname = 'WSS_Profile_differentBC', dpi=100 ))

for iFile in range(len(filenames)):
  sPlot = False
  ePlot = False
  if iFile == 0:
    sPlot = True
  if iFile == (len(filenames)-1):
    ePlot = True

  plot.append(dict(kind = 'xy', 
              data=[filedict[filenames[iFile]][0]+'/tracking/*vel_centerLine*.res'],
              row=[1,-1], col=[1,4],dtype='float', 
              startplot = sPlot, endplot = ePlot,
              xlabel = 'x (m)', 
              ylabel = 'Velocity (m/s)',
              label = labels[iFile], ls = markers[iFile], 
              #xlogscale = True, ylogscale = True,
              #label = '', ls = markers[ifile],
              #ls = '-o', 
              format = 'pdf', figname = 'VelLine_Profile_differentBC', dpi=100 ))

