import math
import glob
import numpy as np
from itertools import *

infiles = $!musubi_path!$
omegas = $!musubi_omega!$

labels = []
for iomega in omegas:
  labels.append('$omega = $'+str(iomega))

def extractL2Norm(infiles, variable):
  filename = variable+"_l2Norm_omega.txt"
  fileID = open(filename, "w")
  fileID.write("#omega \t difference_l2norm \t analy_l2norm \t rel_l2norm\n")
  for ifile in range(len(infiles)):  
    dataFile = glob.glob(infiles[ifile]+'/tracking/*'+variable+'_l2norm*.res')
    data = np.genfromtxt(dataFile[0], dtype = None)
    if data.size == data.shape[0]:
      data.resize(1,data.size)
    diff = data[-1,1]
    anal = data[-1,2]
    fileID.write(str(omegas[ifile])+'\t'+str(diff)+'\t'+str(anal)+'\t'+str(diff/anal*100)+'\n')  
    #print(data[-1,1],data[-1,2])

  fileID.close()
  return filename

vel_file = extractL2Norm(infiles, 'vel')
press_file = extractL2Norm(infiles, 'press')
wss_file = extractL2Norm(infiles, 'wss')


show_plot = False
markers = ['k-x','k-s','k-v','k-*','k-d','k-p']
plot  = []
font_size = 14
figsize=[5,4]
set_majorgrid = True
#font_family = 'sans_serif'
#font_type = 'sans_serif'

markers = ['r-o','b-s','k--','k-*','k-v','kx','k-p','k-^','k+']

plot.append(dict(kind = 'xy', 
            data=[vel_file],
            row=[1,-1], col=[1,4], 
            startplot = True, endplot = True,
            xlabel = 'omega', ylabel = 'Velocity relative l2norm error in \%',
            #label = '', ls = markers[ifile],
            ls = '-o', 
            format = 'pdf', figname = 'Vel_relativeError_omega', dpi=100 ))

plot.append(dict(kind = 'xy', 
            data=[press_file],
            row=[1,-1], col=[1,4], 
            startplot = True, endplot = True,
            xlabel = 'omega', ylabel = 'pressure relative l2norm error in \%',
            #label = '', ls = markers[ifile],
            ls = '-o', 
            format = 'pdf', figname = 'press_relativeError_omega', dpi=100 ))

plot.append(dict(kind = 'xy', 
            data=[wss_file],
            row=[1,-1], col=[1,4], 
            startplot = True, endplot = True,
            xlabel = 'omega', ylabel = 'WSS relative l2norm error in \%',
            #label = '', ls = markers[ifile],
            ls = '-o', 
            format = 'pdf', figname = 'wss_relativeError_omega', dpi=100 ))


