----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!



-- load lua variables from simParam.lua
require "common"

-- seeder parameters
folder = 'mesh'

-- debug
ebug = {debugMode = true, debugFiles = false, debugMesh='debug/' }
minlevel = level

-- bounding cube: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx-dx_offset/2.0, -dx, -dx},
               length = length_bnd
              }

spatial_object = {
  {
    attribute = {
      kind = 'seed',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { length/2.0, dx, dx },
        }
    }
  },
  {
    attribute = {
      kind = 'periodic',
      level = level
    },
    geometry = {
      {
        kind = 'periodic',
        object = {
          plane1 = {
            origin = {-dx,-dx,nDepth*dx+dx/2},
            vec = {{length+2*dx,0.0,0.0},
                 {0.0,length+2*dx,0.0}}
          },
          plane2 = {
            origin = {-dx,-dx,-dx/2},
            vec = {{0.0,length+2*dx,0.0},
                   {length+2*dx,0.0,0.0}}
          }         
        }
      },
      {
        kind = 'periodic',
        object = {
          plane1 = {
            origin = {-dx,-dx/2.,-dx},
            vec = {{length+2*dx,0.0,0.0},
                 {0.0,0.0,length+2*dx}}
          },
          plane2 = {
            origin = {-dx,nWidth*dx+dx/2.,-dx},
            vec = {{0.0,0.0,length+2*dx},
                   {length+2*dx,0.0,0.0}}
          }         
        }
      },
--      {
--        kind = 'periodic',
--        object = {
--          plane1 = {
--            origin = {-dx/2.,-dx,-dx},
--            vec = {{0.0,0.0,length+2*dx},
--                 {0.0,length+2*dx,0.0}}
--          },
--          plane2 = {
--            origin = {length+dx/2.,-dx,-dx},
--            vec = {{0.0,length+2*dx,0.0},
--                   {0.0,0.0,length+2*dx}}
--          }         
--        }
--      }
    }
  },  
  {
    attribute = {
      kind = 'boundary',
      label = 'outlet'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length+dx/2.0+dx_offset,-dx,-dx},
        vec = {{0.0,length+2*dx,0.0},
               {0.0,0.0,length+2*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'inlet'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx/2.0-dx_offset,-dx,-dx},
        vec = {{0.0,length+2*dx,0.0},
               {0.0,0.0,length+2*dx}}
        }
    }
  },
--  {
--    attribute = {
--      kind = 'boundary',
--      label = 'north'
--    },
--    geometry = {
--      kind = 'canoND',
--      object = {
--        origin = {-0.,length,-0.},
--        vec = {{length,0.0,0.0},
--               {0.0,0.0,length}}
--        }
--    }
--  },
--  {
--    attribute = {
--      kind = 'boundary',
--      label = 'south'
--    },
--    geometry = {
--      kind = 'canoND',
--      object = {
--        origin = {0.0,0.0,0.0},
--        vec = {{length,0.0,0.0},
--               {0.0,0.0,length}}
--        }
--    }
--  },
--  {
--    attribute = {
--      kind = 'boundary',
--      label = 'east'
--    },
--    geometry = {
--      kind = 'canoND',
--      object = {
--        origin = {length+dx/2.0,0.0,0.0},
--        vec = {{0.0,length,0.0},
--               {0.0,0.0,length}}
--        }
--    }
--  },
--  {
--    attribute = {
--      kind = 'boundary',
--      label = 'west'
--    },
--    geometry = {
--      kind = 'canoND',
--      object = {
--        origin = {0.0,0.0,0.0},
--        vec = {{0.0,length,0.0},
--               {0.0,0.0,length}}
--        }
--    }
--  },
--  {
--    attribute = {
--      kind = 'boundary',
--      label = 'top'
--    },
--    geometry = {
--      kind = 'canoND',
--      object = {
--        origin = {0.0,0.0,length/2.0+dx+dx/2.0},
--        vec = {{length,0.0,0.0},
--               {0.0,length,0.0}}
--        }
--    }
--  },
--  {
--    attribute = {
--      kind = 'boundary',
--      label = 'bottom'
--    },
--    geometry = {
--      kind = 'canoND',
--      object = {
--        origin = {0.0,0.0,length/2.0-dx+dx/2.},
--        vec = {{length,0.0,0.0},
--               {0.0,length,0.0}}
--        }
--    }
--  }
}  


