----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = false
comm_reduced = true
bc_inlet = 'spc_molefrac'
bc_outlet = 'spc_outlet_vel'
bc_outlet = 'moments_vel'

if bc_type == 'moments' then
  --bc_inlet = 'spc_moments_moleflux'
  --bc_outlet = 'spc_moments_outflow'
  bc_inlet = 'spc_moments_molefrac'
  bc_outlet = 'spc_moments_vel'
  bc_wall = 'spc_moments_wall'
end  

if bc_type == 'BounceBack' then
  bc_inlet = 'spc_molefrac'
  bc_outlet = 'spc_vel_bb'
  bc_wall = 'wall'
end

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'taylorDispersion'
mesh = 'mesh/'

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   
scaling = 'diffusive'

ebug = {logging = {level=1, filename = 'dbg_bgk.out', root_only=false},
         debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
interval_p = tmax_p/100
tmax = 1000--tmax_p/dt
interval = 100
sim_control = {
  time_control = {
    min = 0 ,
    max = {sim=tmax_p,iter=tmax},
    interval = {sim=interval_p,iter=interval} 
  }
}


-- restart
restart = {
      --read = 'restart/taylorDispersion_lastHeader.lua',
      write = 'restart/',
      --time_control = { min = 0, max = tmax_p, interval = {iter=interval}}
      time_control = {
        min = 0 ,
        max = {sim=tmax_p,iter=tmax},
        interval = {sim=interval_p,iter=interval} 
      }
}

physics = { 
            dt = dt, 
            moleDens0=1000.0,
            molWeight0 = m_min 
          }

-- scheme model for single fluid simulation
scheme = {
  identify = {
      label = 'mix',
      kind = 'multi-species_liquid', 
      relaxation = 'bgk', 
      --relaxation = 'mrt', 
-- scheme layout
      layout = 'd3q19'
  },

  mixture = { rho0 = rho0, moleDens0 = 1000.0,
              omega_diff = omega_diff,
              --paramB = 0.01,
              --kine_shear_viscosity = nu,
              omega_kine = 2.0,
              --bulk_viscosity = nu,
              theta_eq = 1.0,
              initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
            },
  -- field which defines fluid or specie
  -- Single fluid simulation
  field = {{
    label = 'H2O'
-- species properties
   ,species = { molweight = mH2O, 
                diff_coeff = { diff_diag, diff_H2O_Na } }
-- Initial condition
   ,initial_condition = { 
      molefraction = IC_H2O,
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'west',
       kind = bc_inlet,
       molefraction = BC_H2O,
       --velocityX = 0.04,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       --order = 2
       molefluxX = moleflux_H2O,
       molefluxY = 0.0,
       molefluxZ = 0.0,
     },
     {
       label = 'east',
       kind = bc_outlet,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       molefraction = IC_H2O,
       pressure = 0.0,
       molefluxX = moleflux_H2O,
       molefluxY = 0.0,
       molefluxZ = 0.0,
     },
     { label = 'north', kind = bc_wall},
     { label = 'south', kind = bc_wall}
    }
  }
 ,{
    label = 'Na'
   ,species = { molweight = mNa, 
                diff_coeff = { diff_H2O_Na, diff_diag } }
   ,initial_condition = {
      molefraction = IC_Na,
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'west',
       kind = bc_inlet,
       molefraction = BC_Na,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       --order = 2
       molefluxX = moleflux_Na,
       molefluxY = 0.0,
       molefluxZ = 0.0,
     },
     {
       label = 'east',
       kind = bc_outlet,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       molefraction = IC_Na,
       pressure = 0.0,
       molefluxX = moleflux_Na,
       molefluxY = 0.0,
       molefluxZ = 0.0,
     },
     { label = 'north', kind = bc_wall},
     { label = 'south', kind = bc_wall}
    }
  }
  }
  -- add initial condition to variable system
  ,add_variable = { name = 'initialMoleFrac', 
    ncomponents = 1, 
    initialMoleFrac = { 
      { kind = 'combined', spatial = IC_H2O  },
      { kind = 'combined', spatial = IC_Na }
    }
  }  

, 
racking = {
--  {
--   label = 'inlet', 
--   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={dx/2.,0.0,zpos},
--                                      vec={0.0,height,0.0},
--                                      segments =nHeight+2 }
--           },
--   format = 'asciiSpatial',
--   time = {min = 0, max = tmax_p, interval = tmax_p}, 
--   ime = {min = 0, max = tmax, interval = 1}, 
--  },
  {
   label = 'hvs', 
   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'},
               {'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'numDensity_phy'}},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={0.0,0.0,zpos},
                                      vec={{length,0.0,0.0},{0.0,height,0.0}},
                                      segments ={nLength+2,nHeight+2} }
           },
   format = 'harvester',
   time_control = {min = 0, max = tmax_p, interval = tmax_p/10}, 
   ime_control = {min = 0, max = tmax, interval = 1}, 
  },
--  {
--   label = 'numDensity', 
--   variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'numDensity_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={0.0,height/2.0,zpos},
--                                      vec={length,0.0,0.0},
--                                      segments =nLength+2 }
--           },
--   format = 'asciiSpatial',
--   time = {min = 0, max = tmax_p, interval = tmax_p/10}, 
--   ime = {min = 0, max = tmax, interval = 1}, 
--  },
--  {
--   label = 'velocity', 
--   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={0.0,height/2.0,zpos},
--                                      vec={length,0.0,0.0},
--                                      segments =nLength+2 }
--           },
--   format = 'asciiSpatial',
--   time = {min = 0, max = tmax_p, interval = tmax_p/10}, 
--   ime = {min = 0, max = tmax, interval = 1}, 
--  },

--  {
--   label = 'point', 
--   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'},
--               {'H2O_numDensity_phy'},{'Na_numDensity_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={length/2.,height/2.,zpos} } },
--   format = 'ascii',
--   time = {min = 0, max = tmax_p, interval = dt*10}, 
--  }
  }
}


