plot  = []

## parameters
tau = 0.001
mNa = 22.98977e-3
import math
xpos = 3.036873
#diff_H2O_Na = 1.31570699e-9
diff_H2O_Na = 1.31570699e+3
omega = 0.95*math.pi
refNumDens = 1.0/1000.0
deltaRho2 = 0.001
length = 2.0*math.pi
n0 = 1000.0
show_plot = True
font_family= 'serif'
font_type= 'Times New Roman'
font_size = 16
figsize = [8,6]

infile_bgk = ['tracking_bgk/mix_point_*.res']
infile_mrt = ['tracking_mrt/mix_point_*.res']

#infile = ['mix_line_*_t32*.res']

plot.append(dict(kind='xy', data=infile_bgk,
                 col=[1,3], npoints = 60, startplot = True,
                 onvertPhy =True, facs=[1e-12,1.0],
                 label = 'LBM BGK', ls = 'k^', lw = 2, xlogscale = True))

plot.append(dict(kind='xy', data=infile_mrt,
                 col=[1,3], npoints = 50, 
                 onvertPhy =True, facs=[1e-12,1.0],
                 label = 'LBM MRT', ls = 'kd', lw = 2, xlogscale = True))


plot.append(dict(kind='function', data=infile_bgk,
                 col=[1,3], points = 100, endplot = True, 
                 fun = lambda *x: n0*tau * ( math.exp( (-1)*((2*math.pi/length)**2.0)
                 *diff_H2O_Na*x[0]) * math.sin((2*math.pi*xpos)/length 
                 + omega)+ deltaRho2 + 1 ),
                 xmin = 1e-4, xmax = 2e-2, ymin = 0.75, ymax = 1.05,
                 xlabel = 'time [$10^{12}s$]', ylabel = 'concentration [$mol/m^3$]',
                 legend = dict(loc=2,size=14), 
                 label = 'Analytic', ls = 'k', lw = 2, 
                 onvertPhy =True, facs=[1e-12,1.0],
                 xlogscale = True))

plot.append(dict(kind='abs_error', data=infile_bgk,
                 col=[1,3], points = 50, 
                 subplot = True, subaxes = [0.5,0.2,0.3,0.3],
                 reference = dict(kind='fun', 
                 fun = lambda *x: n0*tau*( math.exp( (-1)*((2*math.pi/length)**2.0)
                 *diff_H2O_Na*x[0]) * math.sin((2*math.pi*xpos)/length 
                 + omega)+ deltaRho2 + 1 )),
                 ls = 'k', xlogscale = True, ylogscale = True,label='BGK'
                 ))

plot.append(dict(kind='abs_error', data=infile_mrt,
                 col=[1,3], points = 50, endplot = True, 
                 subplot = True, subaxes = [0.5,0.2,0.3,0.3],
                 reference = dict(kind='fun', 
                 fun = lambda *x: n0*tau*( math.exp( (-1)*((2*math.pi/length)**2.0)
                 *diff_H2O_Na*x[0]) * math.sin((2*math.pi*xpos)/length 
                 + omega)+ deltaRho2 + 1 )),
                 xmin = 1e-4, xmax = 2e-2, ymin = 1e-14, ymax = 0.01,
                 #xlabel = 'time [$10^17s$]', ylabel = 'concentration [$mol/m^3$]',
                 legend = dict(loc=3,size=12), 
                 title = 'Deviation', label = 'MRT',
                 ls = 'k--', xlogscale = True, ylogscale = True,
                 onvertPhy =True, facs=[1e-12,1.0],
                 #xticks = [1e-6, 1e-5,1e-4, 1e-3, 1e-2], 
                 #yticks = [1e-16,1e-12, 1e-8, 1e-6, 1e-4, 1e-2],
                 xticks = [1e-4, 1e-3, 1e-2], 
                 yticks = [1e-14,1e-12,1e-10,1e-8, 1e-6, 1e-4, 1e-2],
                 figname = 'solvent_analyticNumericComparisonFixedPos', format = 'eps'
                 ))

#plot.append(dict(kind='xy', data=['tracking/mix_point_*.res'],
#                 row=[1,-1],col=[1,3], startplot = True,
#                 label='H20',ls = '-') ) 
#
#plot.append(dict(kind='xy', data=['tracking_mrt/mix_point_*.res'],
#                 row=[1,-1],col=[1,3], endplot = True,
#                 label='H20 mrt',ls = 'x') ) 

#plot.append(dict(kind='xy', data=['tracking/mix_line_p00000_t32.000E-03.res'],
#                 row=[1,-1],col=[1,10], label='Na',ls = '--'))
#
#plot.append(dict(kind='xy', data=['tracking/mix_line_p00000_t32.000E-03.res'],
#                 row=[1,-1],col=[1,11], endplot = True,
#                 label='Cl',ls = '-', xlabel='length (m)', ylabel ='mole fraction ($\chi_i =n_i/n_t$)',
#                 format = 'eps', figname = 'Solvent_InitialCondition', dpi=100))

