----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"
tracking_fol = './'
scheme_kind = 'bgk'
bc_inlet = 'spc_inlet_ubb'
bc_inlet = 'spc_inlet_eq'
bc_inlet = 'spc_molefrac'

bc_outlet = 'spc_outlet_expol'
bc_outlet = 'spc_outlet_eq'
bc_outlet = 'spc_vel_bb'

bc_mem = 'wall'
bc_mem = 'spc_blackbox_mem_ion'

bc_spacer = 'wall_libb'
bc_spacer = 'wall'

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
control_routine = 'fast'
-- Simulation name
simulation_name = 'spacer'
mesh = 'mesh/'

scaling = 'diffusive'

ebug = {debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}
NOdebug = {logging = {level=10, filename = 'dbg'}}
logging = { level = 3 }

-- Time step settings
interval = tmax_p/100
tmax_int = 100
interval_int = tmax_int/10
sim_control = {
  time_control = {
    max = tmax_p, 
    interval = interval 
  } --time_control end

--  time_control = {
--    max = {iter=tmax_int}, 
--    interval = {iter=interval_int}
--  }
}   ---sim_control end 

physics = { rho0 = rho0_p, 
            dt = dt, 
            --molWeight0 = m_min, 
            --moleDens0 = moleDens0 
            temp0 = 273.0
}

-- scheme model for single fluid simulation
identify = {
    kind = 'multi-species_liquid', 
    --relaxation = 'bgk', 
    relaxation = scheme_kind, 
    --relaxation = 'mrt', 
    -- scheme layout
    layout = 'd3q19'
    --layout = 'd2q9'
}

glob_source = { electric_field = 'electric' }

---mixture table --
mixture = { rho0 = rho0_p, moleDens0 = moleDens0,
            omega_diff = omega_diff,
            --kine_shear_viscosity = nu_phy,
            --bulk_viscosity = 1e-7,
            omega_kine = 2.0, 
            omega_hom = 0.1,
            theta_eq = 1.0,
            temp = 293.15,
            -- just to check for lattice electric field
            --electricField = { 0.0, 1e-8, 0.0},
            --gravityField = { 0.0, 0.0, 0.0},
            initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
          }

-- user variables
variable = {
  {
    name = 'bc_vel',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun = velocity
  },
  { name = 'electric',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun = electric_force 
  }
}

-- field which defines fluid or specie
-- Single fluid simulation
field = {{
  label = 'H2O'
-- species properties
   ,species = { molweight = mH2O, 
                diff_coeff = { diff_diag, diff_H2O_Na, diff_H2O_Cl},
                charge_nr = charge_nr_H2O}
-- Initial condition
   ,initial_condition = { 
      mole_fraction = IC_H2O,
      velocityX = 0.0,--IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = bc_inlet,
       mole_fraction = BC_H2O,
       --order = 2
     },
     {
       label = 'outlet',
       kind = bc_outlet,
       velocity = 'bc_vel'
     },
     { label = 'north', kind = 'wall'},
     { label = 'south', kind = 'wall'},
     { label = 'spacer', kind = bc_spacer}
    }
  }
 ,{
    label = 'Na'
   ,species = { molweight = mNa, 
                diff_coeff = { diff_H2O_Na, diff_diag, diff_Na_Cl },
                charge_nr = charge_nr_Na}
   ,initial_condition = {
      mole_fraction = IC_Na,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = bc_inlet,
       mole_fraction = BC_Na,
       --order = 2
     },
     {
       label = 'outlet',
       kind =  bc_outlet,
       velocity = 'bc_vel'
     },
     { label = 'north', 
       kind = bc_mem,
       transference_number = 0.971 },
     { label = 'south', 
       kind = bc_mem,
       transference_number = (1.0-0.998) },
     { label = 'spacer', kind = bc_spacer}
    }
  }
 ,{
    label = 'Cl'
   ,species = { molweight = mCl, 
                diff_coeff = { diff_H2O_Cl, diff_Na_Cl, diff_diag },
                charge_nr = charge_nr_Cl}
   ,initial_condition = {
      mole_fraction = IC_Cl,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',    ---inlet
       kind = bc_inlet,
       mole_fraction = BC_Cl,
       --order = 2
     },
     {
       label = 'outlet',    ---outlet
       kind =  bc_outlet,
       velocity = 'bc_vel'
     },
     { label = 'north',     ---north
       kind = bc_mem,
       transference_number = (1.0-0.971) },
     { label = 'south', 
       kind = bc_mem,
       transference_number = 0.998 },
     { label = 'spacer', kind = bc_spacer}
    }
  } -- cl
} -- field
  
tracking = {
--  {
--    label = 'vtk',
--    variable = {
--                'vel_mag_phy', 
--                'velocity_phy', 'H2O_mole_fraction', 
--                'Na_mole_fraction', 'Cl_mole_fraction',
--                'charge_density', 'current_density'
--                },
--    folder=tracking_fol,            
--    shape = {kind='all'},
--    output={format='vtk'},
--    time_control={ min=0, max = tmax_p, interval = tmax_p/10}
--    --time_control={ min=0, max = tmax_p, interval = {iter=10}}
--  },
  {
    label = 'moleDensity',
    variable = {'H2O_mole_fraction', 'Na_mole_fraction', 'Cl_mole_fraction'},
    folder=tracking_fol,            
    shape = {kind='canoND', object = { origin = {l_ch/2.0,0.0,0.0},
                                       vec = { {0.0,h_ch,0.0},
                                               {0.0,0.0,w_ch} 
                                       },
                                       segments = { nHeight+2, nWidth+2 } 
                                     }
            },
    reduction = {'average','average','average'},        
    output={format='ascii'},
    time_control={ min=0, max = tmax_p, interval = {iter=100}}
  },
}

NOrestart = {
      ead = 'restart/spacer_lastHeader.lua',
      write = 'restart/',
      time_control = { min = tmax_p, max = tmax_p, interval = interval},
}
