----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"
moleFrac_bc = 'wall'
moleFrac_bc = 'spc_molefrac'
moleFrac_bc = 'spc_molefrac_wtdf'

scheme_kind = 'bgk'
scheme_kind = 'bgk_withthermodynfac'
-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'stefantube'
mesh = 'mesh/'
--mesh = { predefined='cube', 
--         origin = {0.,0.,0.}, 
--         length = length, 
--         refinementLevel = level }

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   
scaling = 'diffusive'

ebug = { logging={level=1, filename='debug'},debugMode = true, debugFiles = true, verbose =  true}

-- Time step settings
interval = tmax_p/10
sim_control = {
  time_control = {
    min = 0,
     max = tmax_p,
      interval = interval }
      }
sim_control = {
  time_control = {
     min = {iter = 0},
      max = {iter = 10},
       interval = {iter = 1}
        }
   }

-- scheme model for single fluid simulation
scheme = {
  identify = {
      label = 'mix',
      kind = 'multi-species_liquid', 
      relaxation = scheme_kind, 
      --relaxation = 'mrt', 
-- scheme layout
      layout = 'd3q19'
      --layout = 'd2q9'
  },

  physics = { rho0 = rho0, 
              dt = dt, 
              temp0 = 1.0,
              molWeigh0 = math.min(mH2O,mNa,mCl) },

  mixture = { rho0 = rho0, moleDens0 = 1000.0, 
              omega_diff = 2.0,
              omega_kine = 2.0,
              theta_eq = 0.0,
	      prop_file = 'H2O_NaCl.dat',
	      temp = 298.15,
              atm_press = 1.01325e5,
              initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
            },
  -- field which defines fluid or specie
  -- Single fluid simulation
  field = {{
    label = 'H2O'
   ,species = { molweight = mH2O, 
                diff_coeff = { diff_diag, diff_H2O_Na, diff_H2O_Cl } }
   ,initial_condition = {
      molefraction = IC_H2O_Linear,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       ind = 'spc_moleflux',
       kind = 'wall',
       molefluxX = 0.0,
       molefluxY = 0.0,
       molefluxZ = 0.0,
     },
     {
       label = 'outlet',
       kind = moleFrac_bc,
       molefraction = moleFrac_H2O_Out
     }
    }
  }
 ,{
    label = 'Na'
-- species properties
   ,species = { molweight = mNa, 
                diff_coeff = { diff_H2O_Na, diff_diag, diff_Na_Cl } }
-- Initial condition
   ,initial_condition = { 
      molefraction = IC_Na_Linear,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = moleFrac_bc,
       molefraction = moleFrac_Na_In
     },
     {
       label = 'outlet',
       kind = moleFrac_bc,
       molefraction = moleFrac_Na_Out
     }
    }
  }
 ,{
    label = 'Cl'
   ,species = { molweight = mCl, 
                diff_coeff = { diff_H2O_Cl, diff_Na_Cl, diff_diag  } }
   ,initial_condition = {
      molefraction = IC_Cl_Linear,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = moleFrac_bc,
       molefraction = moleFrac_Cl_In
     },
     {
       label = 'outlet',
       kind = moleFrac_bc,
       molefraction = moleFrac_Cl_Out
     }
    }
  }
  }
  -- add initial condition to variable system
  ,add_variable = { name = 'initialMoleFrac', 
    ncomponents = 1, 
    initialMoleFrac = { 
      { kind = 'combined', spatial = IC_Na  },
      { kind = 'combined', spatial = IC_Cl },
      { kind = 'combined', spatial = IC_H2O }
    }
  }  

, 
tracking = {
  {
   label = 'line', 
   variable = {{'Na_molefrac'},{'Cl_molefrac'},{'H2O_molefrac'},{'molefrac'}},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={0.0,dx,dx},
                                      vec={length,0.0,0.0},
                                      segments =nLength+2 }
           },
   format = 'asciiSpatial',
   time_control = {min = 0, max = tmax_p, interval = tmax_p}, 
  },
  {
   label = 'point', 
   variable = {{'Na_molefrac'},{'Cl_molefrac'},{'H2O_molefrac'},
               {'Na_moleflux_phy'},{'Cl_moleflux_phy'},{'H2O_moleflux_phy'},
               {'moleflux'},{'velocity'}},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={length-dx/2.,dx,dx} } },
   eduction = {'average','average','average',
                'average','average','average'},    
   format = 'ascii',
   time_control = {min = 0, max = tmax_p, interval = dt*10}, 
  }

--  ,
--  {
--   label = 'point', 
--   variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'Cl_numDensity_phy'},{'numDensity_phy'}},
--   folder = './tracking/',
--   --shape = {kind = 'canoND', object= {origin={length/2.,length/2.0,dx}}},
--   shape = {kind = 'canoND', object= {origin={3.036873,length/2.0,dx}}},
--   format = 'ascii',
--   time = {min = 0, max = tmax_p, interval = tmax_p/tmax}, 
--  }
--  ,
--  {
--   label = 'pointVel', 
--   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'Cl_velocity_phy'},{'velocity_phy'}},
--   folder = './tracking/',
--   --shape = {kind = 'canoND', object= {origin={length/2.,length/2.0,dx}}},
--   shape = {kind = 'canoND', object= {origin={1.518436,3.089233,dx}}},
--   format = 'ascii',
--   time = {min = 0, max = tmax_p, interval = tmax_p/tmax}, 
--  }
--  ,
--  {
--   label = 'plane', 
----   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'Cl_velocity_phy'},{'velocity_phy'},
----               {'H2O_pressure_phy'},{'Na_pressure_phy'},{'Cl_pressure_phy'},{'pressure_phy'}},
----   variable = {{'kinematicpressure', 1, dep = {'initialMoleFrac'}},
----               {'kinematicpressure_phy', 1, dep = {'initialMoleFrac'}}},
--   variable = {{'kinematicpressure_phy', 1, dep = {'initialMoleFrac'}},
--               {'kinematicpressure', 1, dep = {'initialMoleFrac'}},
--               {'velocity_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={0.0,0.0,dx},
--                                      vec={{length,0.0,0.0},{0.0,length,0.0}},
--                                      segments ={nLength+2, nLength+2} }
--           },
--   format = 'harvester',
--   time = {min = 0, max = tmax_p, interval = tmax_p}, 
--  }

  }
}


