-- all units are in physical units
-- length (m)
-- mesh info
-- length of the diffusion tube
height =  0.41*1e-1
nHeight = 50*1
l_h = 5
nLength = nHeight*l_h 
dx = height/nHeight
length = nLength*dx
nLength_bnd = nLength+2
level = math.ceil(math.log(nLength_bnd)/math.log(2))
length_bnd = (2^level)*dx

dx_half = dx*0.5
zpos = dx_half
sph_pos = {0.2,0.2,zpos}
radius = 0.05
Dia = radius*2.0

-- simulation params
tmax_p = 2.0
-- time step size 
dt = 2e-3--tmax_p/tmax
tmax = tmax_p/dt

mH2O = 18.01528e-3 -- H20
mNa = 22.98977e-3 -- Na
mCl = 35.4527e-3  -- Cl
m_min = math.min(mH2O,mNa,mCl)
-- diffusivities
-- diagonals are not important
-- largest diffusivities
--diff_diag = 1.0e-8
--diff_H2O_Na = 1.31570699e-9
--diff_H2O_Cl = 2.097388e-9
--diff_Na_Cl = 2.95407e-11

-- fake diffusivities
diff_diag = 1.0
diff_H2O_Na = 1.31570699e-5
diff_H2O_Cl = 2.097388e-3
diff_Na_Cl = 2.95407e-3


-- pressure in vapor phase
pressure = 99.4e3 --Pa (N/m^2)
-- Temperature in vapor phase
temp = 328.5 --K

-- density
rho0 = 1.0 -- kg/m^3
-- shear viscosity
--nu = 1e-6 --m^2/s
omega_diff = 2.0
nu = (1.0/(3.0*omega_diff))*dx^2/dt

---------------------------------------
-- Initial condition for taylor dispersion
---------------------------------------
deltaP = 5e-4
u_max = deltaP*height*height/(length*1.0*nu)
--print('u_max ', u_max)
--smallness parameter
tau = 0.01
--sharpness
k = 2.0
stripe_cen = length/8.
width = stripe_cen*2.
chi = - math.log(1e-12)

function IC_pressure(x,y,z)
  return rho0*(-deltaP*x/length + deltaP)
end

function IC_velocity(x,y,z)
  return deltaP * height*height*(1.0-((y-height/2.0)/(height/2.0))^2)/(length*1.0*nu)
  --return 0.0
end

function BC_velocity(x,y,z,t)
  return {deltaP * height*height*(1.0-((y-height/2.0)/(height/2.0))^2)/(length*1.0*nu),0.0,0.0}
end
print('u_max ', IC_velocity(0,height, 0)*dt/dx)

function IC_Na(x,y,z)
  return tau + 0.1 * math.exp(-chi*((x-stripe_cen)/(width/2.0))^(2.0*k))
end

function BC_Na(x,y,z,t)
  return tau + 0.1 * math.exp(-chi*((x-stripe_cen)/(width/2.0))^(2.0*k))
end

function IC_H2O(x,y,z)
  na = tau + 0.1 * math.exp(-chi*((x-stripe_cen)/(width/2.0))^(2.0*k))
  return 1.0 - na
end

function BC_H2O(x,y,z,t)
  na = tau + 0.1 * math.exp(-chi*((x-stripe_cen)/(width/2.0))^(2.0*k))
  return 1.0- na
end


