----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true
bc_inlet = 'spc_molefrac_eq'
bc_inlet = 'spc_inlet'
bc_outlet = 'spc_outlet_expol'
bc_outlet = 'spc_vel_bb'
bc_outlet = 'spc_outlet_eq'

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'taylorDispersion'
mesh = 'mesh/'
--mesh = { predefined='cube', 
--         origin = {0.,0.,0.}, 
--         length = length, 
--         refinementLevel = level }

scaling = 'diffusive'

ebug = {logging = {level=1, filename = 'dbg_bgk.out'},
         debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
interval = tmax_p/10
sim_control = {
  time_control = {
    min = 0 ,
    max = tmax_p,
    interval = interval 
  }
}


--sim_control= {
--  time_control = {
--    min = {iter = 0},
--    max = {iter =1 },
--    interval = {iter =1}
--  }
--}

-- restart
estart = {
      --read = 'restart/taylorDispersion_lastHeader.lua',
      write = 'restart/',
      time_control = { min = 0, max = tmax_p, interval = tmax_p/20}
      --time = {min = 0, max = 500, interval = 10 }
}

physics = { rho0 = rho0, 
            dt = dt, 
            --molWeigh0 = m_min,
            moleDens0=1000.0
           }
 
-- scheme model for single fluid simulation
identify = {
    kind = 'multi-species_liquid', 
    --relaxation = 'bgk', 
    relaxation = 'mrt', 
-- scheme layout
    layout = 'd3q19'
    --layout = 'd2q9'
}

mixture = { rho0 = rho0, moleDens0 = 1000.0,
            omega_diff = omega_diff,
            kine_shear_viscosity = nu,
            --omega_kine = 2.0,
            --bulk_viscosity = nu,
            theta_eq = 1.0,
            initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
          }

-- user variables
variable = {
  {
    name = 'BC_velocity',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = BC_velocity
   -- st_fun = { kind = 'combined',
   --           spatial = {predefined='parabol', 
   --                     shape = { kind = 'canoND', object = {origin  = {0.0,-0.0,-dx},
   --                                                          vec = {0.0,height,0.0} } 
   --                             }
   --                     ,amplitude = 0.04
   --                    }         
   --   },
  },
  {
    name = 'vel_zero',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = 0.0
  },
  {
    name = 'bc_vel',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun = BC_velocity
    --operation = {
    --  kind = 'combine',
    --  input_varname = {'BC_velocity','vel_zero','vel_zero'}
    --}  
  },
  { 
    name = 'mf_inlet_H2O',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = BC_H2O 
  },
  { 
    name = 'mf_inlet_Na',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = BC_Na 
  },
  { 
    name = 'outlet_press',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = 0.0 
  },

}

-- field which defines fluid or specie
-- Single fluid simulation
field = {{
  label = 'H2O'
-- species properties
  ,species = { molweight = mH2O, 
               diff_coeff = { diff_diag, diff_H2O_Na } }
-- Initial condition
  ,initial_condition = { 
     mole_fraction = IC_H2O,
     velocityX = IC_velocity,
     velocityY = 0.0,
     velocityZ = 0.0
   }
  ,boundary_condition = {
    {
      label = 'west',
      kind = bc_inlet,
      mole_fraction = 'mf_inlet_H2O',
      velocity = 'bc_vel',
    },
    {
      label = 'east',
      kind = bc_outlet,
      velocity = 'bc_vel',
      pressure = 'outlet_press'
    },
    { label = 'north', kind = 'wall'},
    { label = 'south', kind = 'wall'}
   }
 }
,{
   label = 'Na'
  ,species = { molweight = mNa, 
               diff_coeff = { diff_H2O_Na, diff_diag } }
  ,initial_condition = {
     mole_fraction = IC_Na,
     velocityX = IC_velocity,
     velocityY = 0.0,
     velocityZ = 0.0
   }
  ,boundary_condition = {
    {
      label = 'west',
      kind = bc_inlet,
      mole_fraction = 'mf_inlet_Na',
      velocity = 'bc_vel',
    },
    {
      label = 'east',
      kind = bc_outlet,
      velocity = 'bc_vel',
      pressure = 'outlet_press'
    },
    { label = 'north', kind = 'wall'},
    { label = 'south', kind = 'wall'}
   }
 }
}
 
tracking = {
--  {
--   label = 'inlet', 
--   variable = {'H2O_velocity_phy','Na_velocity_phy','velocity_phy'},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={dx/2.,0.0,zpos},
--                                      vec={0.0,height,0.0},
--                                      segments =nHeight+2 }
--           },
--   format = 'asciiSpatial',
--   time_control = {min = 0, max = tmax_p, interval = tmax_p}, 
--  },
--  {
--   label = 'vtk', 
--   variable = {'H2O_velocity_phy','Na_velocity_phy','velocity_phy',
--               'H2O_mole_density_phy','Na_mole_density_phy','mole_density_phy'},
--   folder = './tracking/',
--   shape = {kind = 'all'
--           },
--   output = {format = 'vtk'},
--   time_control = {min = 0, max = tmax_p, interval = interval}, 
--  },
  {
   label = 'mole_density', 
   variable = {'H2O_mole_density_phy','Na_mole_density_phy','mole_density_phy'},
   folder = './',
   shape = {kind = 'canoND', object= {origin={0.0,height/2.0,zpos},
                                      vec={length,0.0,0.0},
                                      segments =nLength+2 }
           },
   output={format = 'asciiSpatial'},
   time_control = {min = tmax_p, max = tmax_p, interval = tmax_p}, 
  },
--  {
--   label = 'velocity', 
--   variable = {'H2O_velocity_phy','Na_velocity_phy','velocity_phy'},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={0.0,height/2.0,zpos},
--                                      vec={length,0.0,0.0},
--                                      segments =nLength+2 }
--           },
--   output={format = 'asciiSpatial'},
--   time_control = {min = 0, max = tmax_p, interval = tmax_p/10}, 
--  },

--  {
--   label = 'point', 
--   variable = {'H2O_velocity_phy','Na_velocity_phy','velocity_phy',
--               'H2O_mole_density_phy','Na_mole_density_phy'},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={length/2.,height/2.,zpos} } },
--   output={format = 'ascii'},
--   time_control = {min = 0, max = tmax_p, interval = dt*10}, 
--  }
}
