----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true
bc_outlet = 'spc_outlet_expol'

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'taylorDispersion'
mesh = 'mesh/'
--mesh = { predefined='cube', 
--         origin = {0.,0.,0.}, 
--         length = length, 
--         refinementLevel = level }

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   
scaling = 'diffusive'

ebug = {debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
interval = tmax_p/20
sim_control ={
  time_control ={
     min = {iter = 0},
      max = {iter =tmax_p },
       interval = {iter = interval }
        }
   }
sim_control = {
  time_control = {
    min = {iter = 0},
     max = {iter =2},
      interval = {iter =1}
       }
  }
-- scheme model for single fluid simulation
scheme = {
  identify = {
      label = 'mix',
      kind = 'multi-species_liquid', 
      relaxation = 'bgk', 
      --relaxation = 'mrt', 
-- scheme layout
      layout = 'd3q19'
      --layout = 'd2q9'
  },

  physics = { rho0 = rho0, 
              dt = dt, 
              molWeigh0 = m_min },

  mixture = { rho0 = rho0, moleDens0 = 1000.0,
              omega_diff = 2.0,
              --kine_shear_viscosity = nu,
              --omega_kine = 2.0,
              initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
            },
  -- field which defines fluid or specie
  -- Single fluid simulation
  field = {{
    label = 'H2O'
-- species properties
   ,species = { molweight = mH2O, 
                diff_coeff = { diff_diag, diff_H2O_Na } }
-- Initial condition
   ,initial_condition = { 
      molefraction = IC_H2O,
      elocityX = { 
       predefined='parabol', 
                  shape = { kind = 'canoND', object = {origin  = {0.0,-0.0,-dx},
                                                       vec = {0.0,height,0.0} } 
                             }
                 ,amplitude = 0.04
     },
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'west',
       kind = 'spc_inlet_eq',
       molefraction = BC_H2O,
       --velocityX = 0.04,
       elocityX = { kind = 'combined',
                spatial = {predefined='parabol', 
                          shape = { kind = 'canoND', object = {origin  = {0.0,-0.0,-dx},
                                                               vec = {0.0,height,0.0} } 
                                  }
                          ,amplitude = 0.04
                         }         
	      },
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       --order = 2
     },
     {
       label = 'east',
       kind = bc_outlet,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       pressure = 0.0
     },
     { label = 'north', kind = 'wall'},
     { label = 'south', kind = 'wall'},
     { label = 'sphere', kind = 'wall'}
    }
  }
 ,{
    label = 'Na'
   ,species = { molweight = mNa, 
                diff_coeff = { diff_H2O_Na, diff_diag } }
   ,initial_condition = {
      molefraction = IC_Na,
 --     velocityX = 0.0,
      elocityX = { 
       predefined='parabol', 
                  shape = { kind = 'canoND', object = {origin  = {0.0,-0.0,-dx},
                                                       vec = {0.0,height,0.0} } 
                             }
                 ,amplitude = 0.04
     },
       velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'west',
       kind = 'spc_inlet_eq',
       molefraction = BC_Na,
--       velocityX = 0.04,
     elocityX = { kind = 'combined',
       spatial = {predefined='parabol', 
                  shape = { kind = 'canoND', object = {origin  = {0.0,-0.0,-dx},
                                                       vec = {0.0,height,0.0} } 
                             }
                 ,amplitude = 0.04
       }         
     },
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       --order = 2
     },
     {
       label = 'east',
       kind = bc_outlet,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       pressure = 0.0
     },
     { label = 'north', kind = 'wall'},
     { label = 'south', kind = 'wall'},
     { label = 'sphere', kind = 'wall'}
    }
  }
  }
  -- add initial condition to variable system
  ,add_variable = { name = 'initialMoleFrac', 
    ncomponents = 1, 
    initialMoleFrac = { 
      { kind = 'combined', spatial = IC_H2O  },
      { kind = 'combined', spatial = IC_Na }
    }
  }  

, 
tracking = {
  {
   label = 'inlet', 
   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'}},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={dx/2.,0.0,zpos},
                                      vec={0.0,height,0.0},
                                      segments =nHeight+2 }
           },
   format = 'asciiSpatial',
   time_control = {min = 0, max = tmax_p, interval = tmax_p}, 
   ime_control = {min = 0, max = tmax, interval = 1}, 
  },
  {
   label = 'hvs', 
   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'},
               {'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'numDensity_phy'}},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={0.0,0.0,zpos},
                                      vec={{length,0.0,0.0},{0.0,height,0.0}},
                                      segments ={nLength+2,nHeight+2} }
           },
   format = 'harvester',
   time_control = {min = 0, max = tmax_p, interval = tmax_p/20}, 
   ime_control = {min = 0, max = tmax, interval = 1}, 
  },
  {
   label = 'numDensity', 
   variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'numDensity_phy'}},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={0.0,height/2.0,zpos},
                                      vec={length,0.0,0.0},
                                      segments =nLength+2 }
           },
   format = 'asciiSpatial',
   time_control = {min = 0, max = tmax_p, interval = tmax_p/10}, 
   ime_control = {min = 0, max = tmax, interval = 1}, 
  },
  {
   label = 'velocity', 
   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'}},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={0.0,height/2.0,zpos},
                                      vec={length,0.0,0.0},
                                      segments =nLength+2 }
           },
   format = 'asciiSpatial',
   time_control = {min = 0, max = tmax_p, interval = tmax_p/10}, 
   ime_control = {min = 0, max = tmax, interval = 1}, 
  },

  {
   label = 'point', 
   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'velocity_phy'},
               {'H2O_numDensity_phy'},{'Na_numDensity_phy'}},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={length/2.,height/2.,zpos} } },
   format = 'ascii',
   time_control = {min = 0, max = tmax_p, interval = dt*10}, 
  }

--  ,
--  {
--   label = 'point', 
--   variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'Cl_numDensity_phy'},{'numDensity_phy'}},
--   folder = './tracking/',
--   --shape = {kind = 'canoND', object= {origin={length/2.,length/2.0,dx}}},
--   shape = {kind = 'canoND', object= {origin={3.036873,length/2.0,dx}}},
--   format = 'ascii',
--   time = {min = 0, max = tmax_p, interval = tmax_p/tmax}, 
--  }
--  ,
--  {
--   label = 'pointVel', 
--   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'Cl_velocity_phy'},{'velocity_phy'}},
--   folder = './tracking/',
--   --shape = {kind = 'canoND', object= {origin={length/2.,length/2.0,dx}}},
--   shape = {kind = 'canoND', object= {origin={1.518436,3.089233,dx}}},
--   format = 'ascii',
--   time = {min = 0, max = tmax_p, interval = tmax_p/tmax}, 
--  }
--  ,
--  {
--   label = 'plane', 
----   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'Cl_velocity_phy'},{'velocity_phy'},
----               {'H2O_pressure_phy'},{'Na_pressure_phy'},{'Cl_pressure_phy'},{'pressure_phy'}},
----   variable = {{'kinematicpressure', 1, dep = {'initialMoleFrac'}},
----               {'kinematicpressure_phy', 1, dep = {'initialMoleFrac'}}},
--   variable = {{'kinematicpressure_phy', 1, dep = {'initialMoleFrac'}},
--               {'kinematicpressure', 1, dep = {'initialMoleFrac'}},
--               {'velocity_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={0.0,0.0,dx},
--                                      vec={{length,0.0,0.0},{0.0,length,0.0}},
--                                      segments ={nLength+2, nLength+2} }
--           },
--   format = 'harvester',
--   time = {min = 0, max = tmax_p, interval = tmax_p}, 
--  }

  }
}

restart = {
      ead = 'restart/taylorDispersion_lastHeader.lua',
      write = 'restart/',
      time_control = { min = 0, max = tmax_p, interval = tmax_p}
}
