import math
length = 2*math.pi
xcoord = 1.570796326794897E+00#length/4.
ycoord = 3.141592653589793E+00#length/2.

length = 2*math.pi
nLength = 60
dx = length/nLength
tmax_p = 0.05
tmax = 1000
dt = tmax_p/tmax
omega = 2.0
nu = (1.0/(3.0*omega))*dx*dx/dt
show_plot = False
font_size = 16
figsize = [8,6]

dirpath = 'prod/mesh_nLength60/'
files = ['inputphase_shift0theta_eq0','inputphase_shift0theta_eq0.5','inputphase_shift0theta_eq1.0'
        ,'inputphase_shift0.001theta_eq0','inputphase_shift0.001theta_eq0.5','inputphase_shift0.001theta_eq1.0'
        ,'inputphase_shift0.0001theta_eq0','inputphase_shift0.0001theta_eq0.5','inputphase_shift0.0001theta_eq1.0'
         ]
labels = ['$p_1 = 0, \\theta = 0$','$ p_1 = 0, \\theta = 0.5$','$ p_1 = 0, \\theta = 1.0$'
         ,'$p_1 = L/10^3, \\theta = 0$','$ p_1 = L/10^3, \\theta = 0.5$','$ p_1 = L/10^3, \\theta = 1.0$'
         ,'$p_1 = L/10^4, \\theta = 0$','$ p_1 = L/10^4, \\theta = 0.5$','$ p_1 = L/10^4, \\theta = 1.0$'
         ]

markers = ['k-x','k-s','k-v','k-*','k-d','k-p']
plot  = []

markers = ['k-d','k->','k--','k-*','k-v','kx','k-p','k-^','k+']
#markers = ['k-','k--','k-.','k:','k-d','k-p']
#npoints = [10, 15, 35, 25, 35, 35, 40, 45, 50, 55]
npoints = [50, 50, 50, 50, 50, 50,50,50,50]
for ifile in range(len(files)):
  sPlot = False
  ePlot = False
  if ifile == 0:
    sPlot = True
  if ifile == (len(files)-1):
    ePlot = True

  plot.append(dict(kind = 'rel_abs_error', 
              data=[dirpath+files[ifile]+'/tracking/TGV_pointVel_p00000.res'],
              row=[1,-1], col=[1,11], npoints = npoints[ifile], 
              startplot = sPlot, endplot = ePlot,
              reference = dict( kind='fun',
              fun=lambda *x: math.sin(2.0*math.pi*xcoord/length)*math.cos(2.0*math.pi*ycoord/length)\
              *math.exp(-2.0*4.0*math.pi*math.pi*nu*x[0]/(length*length)) ),
              xlabel = 'time [s]', ylabel = 'Relative error',
              #label = '', ls = markers[ifile],
              label = labels[ifile], ls = markers[ifile], 
              ylogscale = True, xlogscale = True,
              #convertPhy = True, facs = [1e1, 1e-6], 
              #xmin = 0.0, xmax = 0.02,
              #xmin = 4.74e-3, xmax = 4.805e-3,ymin = 3.05e-3,ymax=3.0521e-3,
              legend_loc = 4, legend_ncol=3,
              format = 'pdf', figname = 'TGV_Error', dpi=100 ))

#markers = ['k-x','k-s','k-v','k-*','k-d','k-p']
#npoints = [10, 15, 20, 25, 30, 35, 40, 45, 50, 55]
#for ifile in range(len(files)):
#  sPlot = False
#  ePlot = False
#  subplot = False
#  if ifile == 0:
##    sPlot = True
#    subplot = True
#  if ifile == (len(files)-1):
#    ePlot = True
#
#  plot.append(dict(kind = 'error', data=[dirpath+files[ifile]+'/tracking/TGV_pointVel_p00000.res'],
#              row=[1,-1], col=[1,11], npoints = 1000, startplot = sPlot, endplot = ePlot,
#              reference = dict( kind='fun',
#              fun=lambda *x: math.sin(2.0*math.pi*xcoord/length)*math.cos(2.0*math.pi*ycoord/length)\
#              *math.exp(-2.0*4.0*math.pi*math.pi*nu*x[0]/(length*length)) ),
#              xlabel = 'time ($10^3$s)',# ylabel = 'Relative error ($10^-3$)',
#              #label = '', ls = markers[ifile],
#              #label = labels[ifile], 
#              ls = markers[ifile], #xlogscale = True, ylogscale = True,
#              subplot = subplot, subaxes=[0.25,0.25,0.27,0.27],
#              convertPhy = True, facs = [1e3, 1e0], 
#              xmin = 4.74e-0, xmax = 4.805e-0,ymin = 3.05e-3,ymax=3.0521e-3,
#              format = 'pdf', figname = 'TGV_Error', dpi=100 ))                 

#plot.append(dict(kind = 'error', data=['tracking/TGV_pointVel_p00000.res'],
#                 row=[1,-1], col=[1,11], npoints = 10, startplot = True, endplot = True,
#                 reference = dict( kind='file', data=['tracking/TGV_pointVel_p00000.res']),
#                 xlabel = 'time (s)', ylabel = 'Error',label = 'theta\_eq = 0', legendsize = 12, ls = '-o',
#                 format = 'pdf', figname = 'TGV', dpi=100 ))                 
