-- load lua variables from simParam.lua
require "common"
tracking_fol = 'tracking/'
scheme_kind = 'bgk'
bc_inlet = 'spc_inlet_ubb'
bc_inlet = 'spc_inlet_eq'
bc_inlet = 'spc_moments_molefrac'
bc_inlet = 'spc_molefrac'

bc_outlet = 'wall'
bc_outlet = 'spc_outlet_expol'
bc_outlet = 'spc_outlet_eq'
bc_outlet = 'spc_outlet_vel'
bc_outlet = 'spc_moments_vel'
bc_outlet = 'spc_vel_bb'

bc_mem = 'spc_moments_blackbox_mem_ion'
bc_mem = 'wall'
bc_mem = 'spc_blackbox_mem_ion'

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true

---- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
control_routine = 'fast'
-- Simulation name
simulation_name = 'twoChannel'
mesh = 'mesh/'

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   
scaling = 'diffusive'

ebug = {logging = {level=1, filename = 'dbg_bgk.out'},
         debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

logging = {level=5}

-- Time step settings
interval = tmax_p/100
sim_control = {
  time_control = {
    max = tmax_p, 
    interval = interval 
  }
  --time_control = {
  --  max = {iter=1}, 
  --  interval = {iter=1} 
  --}
}

-- restart
NOrestart = {
      ead = 'restart/twoChannel_lastHeader.lua',
      write = 'restart/',
      time_control = { min = 0, max = tmax_p, interval = tmax_p/100}
}

physics = { rho0 = rho0_p, 
            dt = dt, 
            --molWeight0 = m_min, 
            temp0 = 273.0,
            --moleDens0 = moleDens0
}

-- scheme model for single fluid simulation
identify = {
    label = 'mix',
    kind = 'multi-species_liquid', 
    relaxation = scheme_kind, 
    --relaxation = 'mrt', 
    layout = 'd3q19'
    --layout = 'd2q9'
}

glob_source = { electric_field = 'electric' }

mixture = { rho0 = rho0_p, moleDens0 = moleDens0,
            omega_diff = omega_diff,
            --kine_shear_viscosity = nu_phy,
            --bulk_viscosity = 1e-7,
            omega_kine = 2.0,
            omega_hom = 0.0001,
            theta_eq = 1.0,
            temp = 293.15,
            electricField = { 0.0, 1e-9, 0.0},
            gravityField = { deltaP/rho0_p,0.0,0.0},
            initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
}

-- user variables
variable = {
  { 
    name = 'outlet_press',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = 0.0 
  },
  { name = 'electric',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun = electric_force
  }
}

-- field which defines fluid or specie
-- Single fluid simulation
field = {{
  label = 'H2O'
-- species properties
  ,species = { molweight = mH2O, 
                diff_coeff = { diff_diag, diff_H2O_Na, diff_H2O_Cl },
                charge_nr = charge_nr_H2O}
-- Initial condition
  ,initial_condition = { 
     mole_fraction = IC_H2O,
     velocityX = IC_velocity,
     velocityY = 0.0,
     velocityZ = 0.0
   }
  ,boundary_condition = {
    {
      label = 'inlet_dilute',
      kind = bc_inlet,
      mole_fraction = BC_H2O,
    },
    {
      label = 'inlet_concentrate',
      kind = bc_inlet,
      mole_fraction = BC_H2O,
    },
    {
      label = 'outlet_dilute',
      kind = bc_outlet,
      velocity = velocity,
    },
    {
      label = 'outlet_concentrate',
      kind = bc_outlet,
      velocity = velocity,
    },
    { label = 'cem', kind = 'wall'},
    { label = 'aem_dilute', kind = 'wall'},
    { label = 'aem_concentrate', kind = 'wall'}
   }
  }
 ,{
    label = 'Na'
   ,species = { molweight = mNa, 
                diff_coeff = { diff_H2O_Na, diff_diag, diff_Na_Cl },
                charge_nr = charge_nr_Na}
   ,initial_condition = {
      mole_fraction = IC_Na,
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet_dilute',
       kind = bc_inlet,
       mole_fraction = BC_Na,
     },
     {
       label = 'inlet_concentrate',
       kind = bc_inlet,
       mole_fraction = BC_Na,
     },
     {
       label = 'outlet_dilute',
       kind = bc_outlet,
       velocity = velocity,
     },
     {
       label = 'outlet_concentrate',
       kind = bc_outlet,
       velocity = velocity,
     },
     { label = 'cem', 
       kind = bc_mem,
       flux_dir = {0,1,0}, 
       transference_number = 0.971 },
     { label = 'aem_dilute', 
       kind = bc_mem,
       flux_dir = {0,1,0}, 
       transference_number = (1.0-0.998) },
     { label = 'aem_concentrate', 
       kind = bc_mem,
       flux_dir = {0,1,0}, 
       transference_number = (1.0-0.998) },
    }
  }
 ,{
    label = 'Cl'
   ,species = { molweight = mCl, 
                diff_coeff = { diff_H2O_Cl, diff_Na_Cl, diff_diag },
                charge_nr = charge_nr_Cl}
   ,initial_condition = {
      mole_fraction = IC_Cl,
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet_dilute',
       kind = bc_inlet,
       mole_fraction = BC_Cl,
     },
     {
       label = 'inlet_concentrate',
       kind = bc_inlet,
       mole_fraction = BC_Cl,
     },
     {
       label = 'outlet_dilute',
       kind =  bc_outlet,
       velocity = velocity,
     },
     {
       label = 'outlet_concentrate',
       kind =  bc_outlet,
       velocity = velocity,
     },
     { label = 'cem', 
       kind = bc_mem,
       flux_dir = {0,-1,0}, 
       transference_number = (1.0-0.971) },
     { label = 'aem_dilute', 
       kind = bc_mem,
       flux_dir = {0,-1,0}, 
       transference_number = 0.998 },
     { label = 'aem_concentrate', 
       kind = bc_mem,
       flux_dir = {0,-1,0}, 
       transference_number = 0.998 },
    }
  }
 }

tracking = {
  {
    label = 'vtk',
    variable = {
                'vel_mag_phy', 'H2O_mole_density_phy', 
                'Na_mole_density_phy', 'Cl_mole_density_phy',
                'velocity_phy', 'H2O_mole_fraction', 
                'Na_mole_fraction', 'Cl_mole_fraction',
                'charge_density_phy', 'current_density_phy'
                },
    folder=tracking_fol,            
    shape = {kind='all'},
    output={format='vtk'},
    time_control={ min=0, max = tmax_p, interval = tmax_p/100}
    --time_control={ min=0, max = tmax_p, interval = {iter=10}}
  },
--  {
--    label = 'moleDensity',
--    variable = {'H2O_mole_density_phy', 'Na_mole_density_phy', 'Cl_mole_density_phy'},
--    folder=tracking_fol,            
--    shape = {kind='canoND', object = { origin = {0.0,height/2.0,dx/2.},
--                                       vec = {length,0.0,0.0},
--                                       segments = nLength+2}
--            },
--    reduction = {'average','average','average'},        
--    output={format='ascii'},
--    time_control={ min=0, max = tmax_p, interval = {iter=100}}
--  },
--
--  {
--    label = 'inlet_velMax',
--    variable = {
--                {'velMag_phy'},
--                },
--    folder=tracking_fol,            
--    shape = {kind='canoND', object = { origin = {dx/2.,height/2.0,dx/2.}}
--            },
--    format='ascii',
--    time_control={ min=0, max = tmax_p, interval = dt}
--  }
--  ,
--  {
--    label = 'inlet_numDens',
--    variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'Cl_numDensity_phy'},
--                {'numDensity_phy'},
--                {'velocity_phy'},
--                {'H2O_moleflux_phy'},{'Na_moleflux_phy'},{'Cl_moleflux_phy'}},
--    folder=tracking_fol,            
--    shape = {kind='canoND', object = { origin = {dx/2.,0.0,dx/2.},
--                                       vec = {0.0,height,0.0},
--                                       segments = nHeight+2}
--            },
--    format='ascii',
--    reduction={'average','average','average','average','average','average','average','average'},
--    time_control={ min=0, max = tmax_p, interval = tmax_p/tmax}
--  }
--  ,
--  {
--    label = 'outlet_numDens',
--    variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'Cl_numDensity_phy'},
--                {'numDensity_phy'},
--                {'velocity_phy'},
--                {'H2O_moleflux_phy'},{'Na_moleflux_phy'},{'Cl_moleflux_phy'}},
--    folder=tracking_fol,            
--    shape = {kind='canoND', object = { origin = {length-dx/2.,0.0,dx/2.},
--                                       vec = {0.0,height,0.0},
--                                       segments = nHeight+2}
--            },
--    format='ascii',
--    reduction={'average','average','average','average','average','average','average','average'},
--    time_control={ min=0, max = tmax_p, interval = dt}
--  }
--  ,
--  {
--    label = 'aem_numDens',
--    variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'Cl_numDensity_phy'},
--                {'numDensity_phy'},
--                {'H2O_moleflux_phy'},{'Na_moleflux_phy'},{'Cl_moleflux_phy'}},
--    folder=tracking_fol,            
--    shape = {kind='canoND', object = { origin = {0.0,dx/2,dx/2.0},
--                                       vec = {length,0.0,0.0},
--                                       segments = nLength+2}
--            },
--    format='ascii',
--    reduction={'average','average','average','average','average','average','average'},
--    time_control={ min=0, max = tmax_p, interval = dt}
--  }
--  ,
--  {
--    label = 'cem_numDens',
--    variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'Cl_numDensity_phy'},
--                {'numDensity_phy'},
--                {'H2O_moleflux_phy'},{'Na_moleflux_phy'},{'Cl_moleflux_phy'}},
--    folder=tracking_fol,            
--    shape = {kind='canoND', object = { origin = {0.0,height-dx/2.,dx/2.0},
--                                       vec = {length,0.0,0.0},
--                                       segments = nLength+2}
--            },
--    format='ascii',
--    reduction={'average','average','average','average','average','average','average'},
--    time_control={ min=0, max = tmax_p, interval = dt}
--  }
--  ,
--  {
--    label = 'tot_numDens',
--    variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'Cl_numDensity_phy'},
--                {'numDensity_phy'},
--                },
--    folder=tracking_fol,            
--    shape = {kind='all'},
--    format='ascii',
--    reduction={'average','average','average','average'},
--    time_control={ min=0, max = tmax_p, interval = dt}
--  }
--
}
