require "common"

-- Musubi configuration file. 
-- This is a LUA script.
interpolation_method = 'quadratic'

-- Simulation name
mesh = 'mesh/' -- Mesh information
debug = {debugMode = true, debugFiles = true, dumpDependencies = true}
simulation_name = 'channelRefine'
identify = {label = idLabel, layout='d3q19'}

-- Time step settigs
tmax =    1 --nIters    -- total iteration number
interval = tmax/10
tRamping = tmax/20
time = {useIterations = true,
        min = 1, max = tmax, interval = interval }

fluid = { --omega_ramping = { predefined='smooth', min_factor = 0.7, max_factor=1, from_time=0, to_time=tRamping}, 
       omega = omega, 
       rho0 = 1.0 }
u0 = 0.0
amplitude = 0.01
dp = 0.001
p0 = 1.
function ini_rho(x, y, z)
  return p0 - dp/length*x+dp*0.5
end

function ini_functionY(x, y, z)
  return (amplitude - amplitude*4/(height^2)*y^2)  --*(1.-0.2/length*x)
end
function ini_functionZ(x, y, z)
  return (amplitude - amplitude*4/(height^2)*z^2)  --*(1.-0.2/length*x)
end
function ini_function3d(x, y, z)
  if y^2 + z^2 >= height^2/4 then
    return 0
  else
    return (amplitude - amplitude*8/(height^2)*(y^2+z^2))  --*(1.-0.2/length*x)
  end
end
-- Initial condition 
initial_condition = { density =ini_rho, 
                      velocityX = ini_functionZ, --3d,
                      velocityY = ini_functionY,
                      velocityZ = 0.0 }

-- Boundary conditions
boundary_condition = {  
{ label = 'west', 
  kind = 'inlet_ubb', 
  velocityX = { kind = 'combined',
                transient= {
                  predefined='smooth', 
                  min_factor = 0.0, 
                  max_factor=1.0, 
                  from_time=0, 
                  to_time=tRamping}, 
                spatial = {
                  predefined='parabol', 
                  shape = { 
                    kind = 'canoND', 
                    object = {
                      origin = {-0.5*length, -(height-0.5*dx)*0.5, 0.0},
                      vec = {0.0, height-0.5*dx, 0.0} 
                      } 
                   }
                  ,amplitude = u_in 
              }         
	      },
   velocityY = 0.0, velocityZ = 0.0},
{ label = 'east',
   kind = 'outlet_pab',
   density =  1.0}, 
{ label = 'north', 
   kind = 'wall' },
{ label = 'south', 
   kind = 'wall' },
 }

if usePeriodic ==false then
  table.insert( boundary_condition, 
{ label = 'front', 
   kind = 'wall' } )
  table.insert( boundary_condition, 
{ label = 'back', 
   kind = 'wall' } )
end
if useObstacle ==true then
  table.insert( boundary_condition, 
{ label = 'sphere', 
   kind = 'wall' } )
 end




-- Output settings
output = { active = true, -- VTK output activated?
  folder = './output/'..label..'_l'..level,     -- Output location
  vtk = false,             -- VTK output activated?
  wss = true, 
  dumpGhosts = true,
  time = {min = tmax-20, max = tmax, interval = 1} --interval}
}

-- Tracking              
tracking = {{
  label = label..'_probePressure_l'..level, 
 variable = {'density'}, 
 shape = {kind = 'canoND', object = {origin ={0.0,0.,0.} } },
 time = {min = 1, max = tmax, interval = 5},
  format = 'ascii', folder = './tracking/'      
 }, 
{
  label = label..'_velX2_l'..level, 
 variable = {'velocity', 'shearstress'}, 
 shape = {kind = 'canoND', object = {origin ={ length*0.35,-height*0.5,0.}, vec={0., height, 0.}, segments = 2*nElemsMax } },
 time = {min = tmax, max = tmax, interval = interval},
  format = 'asciiSpatial'      , folder = './tracking/'      
 },
{
  label = label..'_pressCutY_l'..level, 
 variable = {'density'}, 
 shape = {kind = 'canoND', 
          object = {
            origin ={0., -height*0.5,0.,0.}, 
            vec={0., height, 0.}, 
            segments = 2*nElemsMax } },
 time = {min = tmax, max = tmax, interval = interval},
  format = 'asciiSpatial'      , folder = './tracking/'      
 }
,
{
  label = label..'_pressCutX_l'..level, 
 variable = {'density', 'shearstress'}, 
 shape = {kind = 'canoND', 
          object = {
              origin ={-length*0.5,0.,0.}, 
              vec={length, 0., 0.}, 
              segments = 2*nElemsMax } 
          },
 time = {min = tmax, max = tmax, interval = interval},
  format = 'asciiSpatial'      , folder = './tracking/'      
 }} 

