set term postscript enhanced color font "Times-Roman,16"
set output "initialCondition.ps"

reset
unset key
set key right top

# the parameters of the initial conditions (have a look at the paper for the parameters)
C1 = 0.1
deltaRho1 = (1-C1-C1)/3

# the size of the domain
length = 0.0001*2*pi
deltaX = length/20

# some physical parameters of the species
molecularWeight1 = 18.01528e-3 
molecularWeight2 = 22.98977e-3 
molecularWeight3 = 35.4527e-3  

# the initial conditions of the different species
iniCond1(x) = ((C1/2) * (1-tanh((x-(length/4))/deltaX)) + deltaRho1)/molecularWeight1
iniCond2(x) = ((C1/2) * (1+tanh((x-(length/4))/deltaX)) + deltaRho1)/molecularWeight2
iniCond3(x) = (1-iniCond1(x)*molecularWeight1 - iniCond2(x)*molecularWeight2)/molecularWeight3


bm = 0.15
lm = 0.12
rm = 0.95
gap = 0.03
size = 0.75

set multiplot
set xlabel 'x'
set border 1+2+8
set xtics nomirror
set ytics nomirror
set lmargin at screen lm
set rmargin at screen rm
set bmargin at screen bm
set tmargin at screen bm + size

set xrange [0:length/2]

set label 'concentration [mol/m^3]' at screen 0.03, bm + 0.5 * (size + 2*gap) offset 0,-strlen("concentration [mol/m^3]")/4.0 rotate by 90

plot iniCond1(x) w l title 'species 1' lt 3, \
     iniCond2(x) w l title 'species 2' lt 1, \
     iniCond3(x) w l title 'species 3' lt 2


