set term postscript enhanced color font "Times-Roman,16"
set output "simResultSpecies3_matlabVsMusubi.ps"

reset
unset key
set key right top

# the parameters of the initial conditions (have a look at the paper for the parameters)
C1 = 0.1
deltaRho1 = (1-C1-C1)/3

# the size of the domain
length = 0.00001*2*pi
deltaX = length/20
refDens = 1000.0

# some physical parameters of the species
molecularWeight1 = 18.01528e-3 
molecularWeight2 = 22.98977e-3 
molecularWeight3 = 35.4527e-3  

# the initial conditions of the different species
iniCond1(x) = refDens*((C1/2) * (1-tanh((x-(length/4))/deltaX)) + deltaRho1)/molecularWeight1
iniCond2(x) = refDens*((C1/2) * (1+tanh((x-(length/4))/deltaX)) + deltaRho1)/molecularWeight2
iniCond3(x) = (refDens-iniCond1(x)*molecularWeight1 - iniCond2(x)*molecularWeight2)/molecularWeight3


bm = 0.15
lm = 0.12
rm = 0.95
gap = 0.03
size = 0.75

set multiplot
set xlabel 'x'
set border 1+2+8
set xtics nomirror
set yrange [10342.0:10342.8]
set ytics 10342.0,0.8 #nomirror
set lmargin at screen lm
set rmargin at screen rm
set bmargin at screen bm
set tmargin at screen bm + size

set xrange [0:length/2]

set label 'concentration [mol/m^3]' at screen 0.03, bm + 0.5 * (size + 2*gap) offset 0,-strlen("concentration [mol/m^3]")/4.0 rotate by 90

#plot iniCond1(x) w l title 'initial' lt 3, \
#     'density1DSpecies1.dat' using ($1):($2/molecularWeight1) title 'sim', \
#     iniCond2(x) w l title 'initial' lt 1, \
#     'density1DSpecies2.dat' using ($1):($2/molecularWeight2) title 'sim', \
#     iniCond3(x) w l title 'initial' lt 2, \
#     'density1DSpecies3.dat' using ($1):($2/molecularWeight3) title 'sim result'

plot iniCond3(x) w l title 'initial' lt 2, \
     'density1DSpecies3.dat' using ($1):($2*refDens/molecularWeight3) every 2 title 'Matlab t=1*10^-5' with points pt 8 linecolor rgb "red", \
     'musubiRes/mix_line_p00000_t10.000E-06.res' using 1:6 every 2 title 'Musubi t=1*10^-5' with lines lt 7 linecolor rgb "red", \
     'density1DSpecies3.dat2' using ($1):($2*refDens/molecularWeight3) every 2 title 'Matlab t=2*10^-5' with points pt 19 linecolor rgb "blue",\
     'musubiRes/mix_line_p00000_t20.000E-06.res' using 1:6 every 2 title 'Musubi t=2*10^-5' with lines lt 14 linecolor rgb "blue"

