----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'multispecies'
mesh = 'mesh/'
--mesh = { predefined='cube', 
--         origin = {0.,0.,0.}, 
--         length = length, 
--         refinementLevel = level }

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   
scaling = 'diffusive'

ebug = {debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
interval = tmax_p/10
 sim_control = {
   time_control = {
     min = 0,
      max = tmax_p ,
        interval = interval
        }
 }
--time = {useIterations = true,
--        min = 0, max = 1, interval = 1 }

-- scheme model for single fluid simulation
scheme = {
  identify = {
      label = 'mix',
      kind = 'multi-species_liquid', 
      --relaxation = 'bgk', 
      --relaxation = 'mrt', 
-- scheme layout
      layout = 'd3q19'
      --layout = 'd2q9'
  },

  physics = { rho0 = rho0_p, 
              dt = dt, 
              molWeigh0 = m_min },

  mixture = { rho0 = rho0_p, 
              omega_diff = 2.0,
              --kine_shear_viscosity = nu_p,
              omega_kine = 2.0,
              initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
            },
  -- field which defines fluid or specie
  -- Single fluid simulation
  field = {{
      label = 'H2O'
-- species properties
     ,species = { molweight = mH2O, diff_coeff = { diff_diag, diff_H2O_Na, diff_H2O_Cl } }
-- Initial condition
     ,initial_condition = { 
         molefraction = molefrac_H2O,
         velocityX = 0.0,--TGV_velocityX,
         velocityY = 0.0,--TGV_velocityY,
         velocityZ = 0.0}
     }
   ,{
     label = 'Na'
    ,species = { molweight = mNa, diff_coeff = { diff_H2O_Na, diff_diag, diff_Na_Cl } }
    ,initial_condition = {
         molefraction = molefrac_Na,
         velocityX = 0.0,--TGV_velocityX,
         velocityY = 0.0,--TGV_velocityY,
         velocityZ = 0.0}
    }
   ,{
     label = 'Cl'
    ,species = { molweight = mCl, diff_coeff = { diff_H2O_Cl, diff_Na_Cl, diff_diag } }
    ,initial_condition = {
         molefraction = molefrac_Cl,
         velocityX = 0.0,--TGV_velocityX,
         velocityY = 0.0,--TGV_velocityY,
         velocityZ = 0.0}
    }
  }
  -- add initial condition to variable system
  ,add_variable = { name = 'initialMoleFrac', 
    ncomponents = 1, 
    initialMoleFrac = { 
      { kind = 'combined', spatial = molefrac_H2O },
      { kind = 'combined', spatial = molefrac_Na },
      { kind = 'combined', spatial = molefrac_Cl }
    }
  }  

, 
tracking = {
  {
   label = 'line', 
   ariable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'Cl_numDensity_phy'},{'density'},{'density_phy'}},
   variable = {{'density'},{'numDensity_phy'},{'molefrac'}},
   folder = './tracking/',
   shape = {kind = 'canoND', object= {origin={0.0,length/2.0,dx},
                                      vec={length,0.0,0.0},
                                      segments =nLength+2 }
           },
   format = 'asciiSpatial',
   time_control = {min = 0, max = tmax_p, interval = tmax_p/2}, 
  }
--  ,
--  {
--   label = 'point', 
--   variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'Cl_numDensity_phy'},{'numDensity_phy'}},
--   folder = './tracking/',
--   --shape = {kind = 'canoND', object= {origin={length/2.,length/2.0,dx}}},
--   shape = {kind = 'canoND', object= {origin={3.036873,length/2.0,dx}}},
--   format = 'ascii',
--   time = {min = 0, max = tmax_p, interval = tmax_p/tmax}, 
--  }
--  ,
--  {
--   label = 'pointVel', 
--   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'Cl_velocity_phy'},{'velocity_phy'}},
--   folder = './tracking/',
--   --shape = {kind = 'canoND', object= {origin={length/2.,length/2.0,dx}}},
--   shape = {kind = 'canoND', object= {origin={1.518436,3.089233,dx}}},
--   format = 'ascii',
--   time = {min = 0, max = tmax_p, interval = tmax_p/tmax}, 
--  }
--  ,
--  {
--   label = 'plane', 
----   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'Cl_velocity_phy'},{'velocity_phy'},
----               {'H2O_pressure_phy'},{'Na_pressure_phy'},{'Cl_pressure_phy'},{'pressure_phy'}},
----   variable = {{'kinematicpressure', 1, dep = {'initialMoleFrac'}},
----               {'kinematicpressure_phy', 1, dep = {'initialMoleFrac'}}},
--   variable = {{'kinematicpressure_phy', 1, dep = {'initialMoleFrac'}},
--               {'kinematicpressure', 1, dep = {'initialMoleFrac'}},
--               {'velocity_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={0.0,0.0,dx},
--                                      vec={{length,0.0,0.0},{0.0,length,0.0}},
--                                      segments ={nLength+2, nLength+2} }
--           },
--   format = 'harvester',
--   time = {min = 0, max = tmax_p, interval = tmax_p}, 
--  }

  }
}


