-- load lua variables from simParam.lua
require "common"
tracking_fol = './tracking/'
scheme_kind = 'bgk'

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true

---- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
control_routine = 'fast'
-- Simulation name
simulation_name = 'nernstPlanck'
mesh = 'mesh/'

scaling = 'diffusive'
logging = {level=10}

ebug = {logging = {level=1, filename = 'dbg_bgk.out'},
         debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
interval = tmax_p/100
sim_control = {
  time_control = {
    max = {sim=tmax_p}, 
    interval = interval,
    check_iter = 1
  }
  --time_control = {
  --  max = {iter=100}, 
  --  interval = {iter=10} 
  --}
}

-- restart
NOrestart = {
  --read = 'restart/taylorDispersion_header_25.004E-03.lua',
  NOread = 'restart/nernstPlanck_lastHeader.lua',
  write = 'restart/',
  time_control = { min = tmax_p, max = tmax_p, interval = tmax_p}
}

physics = { rho0 = rho0_p, 
            dt = dt, 
            --molWeight0 = m_min, 
            temp0 = 273.0,
            --moleDens0 = moleDens0,
            --coulomb0 = 1.0
}

-- scheme model for single fluid simulation
identify = {
    kind = 'nernst_planck', 
    relaxation = scheme_kind, 
-- scheme layout
    layout = 'd3q19'
}

glob_source = { electric_field = 'electric' }

nernst_planck = { mole_density = mole_density,
            temp = 293.15,
          }

transport_velocity = velocity_fluid 

-- user variables
variable = {
  { name = 'electric',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun = {0.0,1000,0.0}
  }
}
-- field which defines fluid or specie
-- Single fluid simulation
field = {{
    label = 'Na'
   ,species = { molweight = mNa, 
                diff_coeff = {diff_H2O_Na,diff_diag},
                charge_nr = charge_nr_Na}
   ,initial_condition = {
      mole_fraction = IC_Na,
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    },
    boundary_condition = {
      {
	label = 'north',
	kind = 'wall'
      },
      {
	label = 'south',
	kind = 'wall'
      }
    }
  }
 ,{
    label = 'Cl'
   ,species = { molweight = mCl, 
                diff_coeff = {diff_H2O_Cl,diff_diag},
                charge_nr = charge_nr_Cl}
   ,initial_condition = {
      mole_fraction = IC_Cl,
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    },
    boundary_condition = {
      {
	label = 'north',
	kind = 'wall'
      },
      {
	label = 'south',
	kind = 'wall'
      }
    }
  }
}
tracking = {
  {
    label = 'vtk',
    variable = {
                'Na_mole_density_phy', 'Cl_mole_density_phy',
                },
    folder=tracking_fol,            
    shape = {kind='all'},
    output={format='vtk'},
    time_control={ min=0, max = tmax_p, interval = tmax_p/25}
    --time_control={ min=0, max = tmax_p, interval = {iter=10}}
  },
  {
    label = 'moleDensity',
    variable = {'Na_mole_density_phy', 'Cl_mole_density_phy'},
    folder=tracking_fol,            
    shape = {kind='canoND', object = { origin = {0.0,height/2.0,dx/2.},
                                       vec = {length,0.0,0.0},
                                       segments = nLength+2}
            },
    reduction = {'average','average'},        
    output={format='ascii'},
    time_control={ min=0, max = tmax_p, interval = {iter=100}}
  },
} -- tracking
