import os
apesFolder = os.getenv('HOME')+'/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'convergence_inlet_ubb'
loglevel = 'INFO'
shepherd_jobs = []

run_seeder = False
run_seeder = True

run_musubi = False
run_musubi = True

run_hvs = True
run_hvs = False

run_glr = True
run_glr = False

run_coeff = True
run_coeff = False

submit_job = True
submit_job = False


shepherd_jobs.append(dict(executable=apesFolder+'seeder/build/seeder',
                          template='seeder.template',
                          extension='lua',
                          run_exec = run_seeder,
                          run_command = '',
                          params = [
                                        ['nHeight', 16,25,32, 50,64],#, 100,128, 200,256,512]
                                    #['nHeight', 16]
                                   ] ,
                          additional_params = dict(MESH='mesh/',
                                                   stl_file=os.getcwd()+'/cylinder_para.stl'),
                          create_subdir = ['mesh'],
                          prefix = 'sdr',
                          label = 'seeder'))

# shepherd_jobs.append(dict(executable=apesFolder+'harvester/build/harvester',
#                           template='harvester.template',
#                           extension='lua',
#                           run_exec = False,
#                           run_command = '',
#                           create_subdir = ['harvest'],
#                           depend = ['seeder'],
#                           prefix = 'hvs',
#                           label = 'hvs'))

shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                          template='musubi.template',
                          extension='lua',
                          run_exec = run_musubi,
                          run_command = 'mpirun -np 16',
                          params = [],
				    #['inletBC', 'inlet_ubb','outlet_expol']],
                                    #['outletBC', 'outlet_expol'],
				    #['inletBC', 'outlet_expol']],
				    #, 'outlet_nrbc']],
                                    #['stencil', 'd3q19','d3q27']],
                          additional_params = dict(MESH='../mesh/',inletBC='inlet_ubb',outletBC='outlet_expol',omega='1.8'),
                          create_subdir = ['tracking','restart'],
                          prefix = 'mus',
                          depend = ['seeder'],
                          create_depend_path = True,
                          label = 'musubi'))

shepherd_jobs.append(dict(executable=None,
                          template='horus.template',
                          extension='sh',
                          run_exec = submit_job,
                          run_command = 'sbatch',
                          params = [
                                    ["nNodes", 2]
                                   ],
                          create_dir = False,
                          create_depend_path = True,
                          depend = ['musubi'],
                          label = 'horus'))

shepherd_jobs.append(dict(executable=None,
                          template='printSimParam.template',
                          extension='lua',
                          run_exec = False,
                          run_command = '',
                          depend = ['seeder','musubi'],
                          create_depend_path = True,
                          label = 'print'))

#shepherd_jobs.append(dict(executable=apesFolder+'harvester/gleaner/gleaner.py',
#                          template = 'params_plot.template',
#                          extension = 'py',
#                          run_exec = run_glr,
#                          run_command = '',
#                          run_last = True,
#                          depend = ['seeder','musubi'],
#                          create_depend_path = True,
#                          create_depend_params = True,
#                          label = 'glr'))

shepherd_jobs.append(dict(executable=apesFolder+'harvester/gleaner/gleaner.py',
                          template = 'params_plot_error.template',
                          extension = 'py',
                          run_exec = run_glr,
                          run_command = '',
                          run_last = True,
                          depend = ['seeder','musubi'],
                          create_depend_path = True,
                          create_depend_params = True,
                          label = 'glr'))

#shepherd_jobs.append(dict(executable=apesFolder+'harvester/gleaner/gleaner.py',
#                          template = 'scatter.template',
#                          extension = 'py',
#                          run_exec = run_glr,
#                          run_command = '',
#                          run_last = True,
#                          depend = ['seeder','musubi'],
#                          create_depend_path = True,
#                          create_depend_params = True,
#                          label = 'glr'))

#shepherd_jobs.append(dict(executable=apesFolder+'harvester/scripts/harvest_series.py',
#                          template = 'params_hvs.py',
#                          extension = 'py',
#                          run_exec = run_hvs,
#                          run_command = '',
#                          input_option = '--config',
#                          depend = ['musubi'],
#                          #run_last = True,
#                          #create_depend_path = True,
#                          #create_depend_params = True,#["musubi_phase_shift","musubi_theta_eq"],
#                          label = 'hvs'))


# shepherd_jobs.append(dict(executable=None,
#                           template = 'get_coeff_max.template',
#                           extension = 'py',
#                           run_exec = run_coeff,
#                           run_command = 'python3',
#                           input_option = '',
#                           depend = ['musubi'],
#                           create_depend_path = True,
#                           create_depend_params = True,
#                           label = 'coeff'))

