-- Use this file as template. Do not modify this file for running some testcases

-- parameters taken from common.lua

-------------------------
-- Geometry definition --
-------------------------

Dia =  0.41
radius = Dia/2.
-- polar coordinates, origin in tube center position
height = Dia               -- y direction
width = Dia                -- z direction
nHeight = 64
l_h = 5.0 -- ratio between length and diameter
nLength = nHeight*l_h 
dx = height/nHeight  
--length = nLength*dx
nLength_bnd = nLength+2
level = math.ceil(math.log(nLength_bnd)/math.log(2))
length_bnd = (2^level)*dx

dx_half = dx*0.5
zpos = dx_half
offset = 0.0      --height/2.0
dx_eps = length_bnd/2^10
qval = true                -- activates q-values 

-- parameters from common.lua end here
-- parameters from stl file cylinder.stl

-------------------------
-- Range of the tube   --
-------------------------

x_min = 0
x_max = 2.87
y_min = -0.205
y_max = 0.205
z_min = -0.205
z_max = 0.205
length = x_max - x_min

---------------------
---------------------


west_label = 'inlet'
east_label = 'outlet'


---------------------
---------------------


folder = 'mesh/'
logging = {level=10}
ebug = {debugMode = true, debugFiles=true}

----------------------
-- bounding cube    --
----------------------


-- two entries: origin and length in this
-- order, if no keys are used

bounding_cube = {origin = {x_min-dx,y_min-dx,z_min-dx},
               length = length_bnd}

minlevel = level

----------------------
-- spatial object   --
----------------------

spatial_object = {
  {
    attribute = {
      kind = 'seed',  ------seed
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {x_min+length/2.,y_min+height/2.,z_min+height/2. },
        } --- object
    }
  },
  {
    attribute = {
      kind = 'boundary',
      level = level,
      label = west_label -- for inlet
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {x_min-dx_eps,y_min-dx,z_min-dx},
        vec = {{0.0,height+2.*dx,0.0},
               {0.0,0.0,height+2.*dx}}
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      level = level,
      label = east_label     --- for outlet
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {x_max+dx_eps,y_min-dx,z_min-dx},
        vec = {{0.0,height+2.*dx,0.0},
               {0.0,0.0,height+2.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'cylinder',
      calc_dist = qval,
      level = level,
      distance_refine = {
        {
           radius = dx*5,
           level_offset = 0
        },
        {
           radius = length_bnd/2^(level-1)*5,
           level_offset = -1
        },
    }
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = 'pipe.stl',
        format = 'binary'
      }
    },
	
  },
}
