----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!
-- Musubi configuration file. 
require "common"
tracking_fol = 'tracking/'
restart_fol = 'restart/'

-- Simulation name
simulation_name = 'poisson'
--mesh = 'mesh/' -- Mesh information
mesh = {
  predefined = 'line',      -- use the predefined full cube
  origin = {                -- origin of the cube
    (-1.0)*length/2.0,
    -dx/2.0,--(-1.0)*length/2.0,
    -dx/2.0
  },
  length = length,     -- length of the cube
  refinementLevel = level       -- refinement level to resolve the cube
}

printRuntimeInfo = false

scaling = 'diffusive'
control_routine = 'fast'
io_buffer_size = 10 -- default is 80 MB
logging = {level=10}

tmax = 1e7 
-- Time step settigs
sim_control = {
  time_control = { 
    max = {iter=tmax},
    interval = {iter=tmax/10}
  } -- time control
 ,abort_criteria = {
    steady_state = false,
    convergence = {
      variable = {'potential_phy'}, 
      shape = {
        kind = 'canoND',
        object = {origin = {0.0,0.0,0.0}}
      },
      time_control = {min = 0, max = {iter=tmax}, interval = {iter=10}},
      reduction = 'average',
      norm='average', nvals = 50, absolute = true,
      condition = { threshold = 1.e-15, operator = '<=' }
    }
  }
} -- simulation control

-- restart 
restart = {
  NOread = restart_fol..'Poisson_lastHeader.lua',
  write = restart_fol,
 }

logging = {level=10}

-- needed to dump variable in physical unit
physics = { dt = dt, rho0=1000.0, temp0=273.0 }

poisson = { 
  potential_diffusivity = 0.0001, 
  permittivity=permit, 
  poisson_boltzmann = {
    moleDens0 = moleDens0,
    temp = temp, 
    valence={1.0,-1.0}, 
  }  
}

-- Initial condition 
initial_condition = { potential = ref_pot }

identify = {
  layout='d3q19',
  kind='poisson', 
  relaxation = 'bgk'
}

boundary_condition = {
  {
    label = 'zero_potential',
    NOkind = 'potential_dirichlet',
    kind = 'potential_neumann',
    NOkind = 'wall',
    potential = analy_pot
  }
}

glob_source = {
  charge_density = 'chargedens_sphere'
}
variable = {
  {
    name = 'analy_pot',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = analy_pot
  },
  {
    name = 'chargedens_sphere',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = { 
      predefined = 'combined',  
      spatial = chargedens_sphere,
    }
  },
}

-- Tracking
tracking = {
  {
    label = 'line', 
    folder = tracking_fol,
    variable = {'potential_phy','analy_pot','chargedens_sphere'}, 
    shape = {
      kind = 'canoND', 
      object = {
        origin ={-length/2.0,0.0,0.0},
        vec = {length,0.0,0.0},
        segments = nLength
      }
    },
    time_control = {min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax}},
    output={format = 'asciiSpatial'}
  },
  {
    label = 'probe', 
    folder = tracking_fol,
    variable = {'potential_phy'}, 
    shape = {
      kind = 'canoND', 
      object = {
        origin ={0.0,0.0,0.0},
      }
    },
    time_control = {min = {iter=0}, max = {iter=tmax}, interval = {iter=1000}},
    output={format = 'ascii'}
  },

--  {
--    label = 'vtk', 
--    folder = tracking_fol,
--    variable = {'potential_phy','analy_pot','chargedens_sphere','electric_field_phy'}, 
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={-length/2.0,-length/2.0,0.0},
--        vec = {
--          {length,0.0,0.0},
--          {0.0, length,0.0},
--        },  
--        segments = {nLength,nLength}
--      }
--    },
--    time_control = {min = {iter=0}, max = {iter=tmax}, interval = {iter=tmax/10}},
--    output={format = 'vtk'}
--  },

}

