## This is the user-script for plotting using gleaner tool.
import sys
import os
# Path to gleaner (Better use environment variable PYTHONPATH!)
glrPath = os.getenv('HOME')+'/apes/gleaner'

sys.path.append(glrPath)
import gleaner
import logging

import matplotlib.ticker as mtick
from mpl_toolkits.mplot3d import Axes3D
import matplotlib.pyplot as plt
from matplotlib import cm

# font setting
#from matplotlib import rc
#font_size = 12
#font_family = 'serif'
#font_type = 'Times New Roman'
#rc('text',usetex=True)
#font = {'family':font_family,'%s'%font_family:font_type,'size':font_size}
#rc('font',**font)
#
##axis without scientific notation
#y_formatter = mtick.ScalarFormatter(useOffset=False)


# data base filename
dbname = 'track.db'
dbname = 'memory'

# load database if exist else load tracking files and add to database
#if os.path.isfile(dbname):
#  print ('Processing data from existing database')
##  os.remove(dbname)
#  import sqlite3
#  sqlcon = sqlite3.connect(dbname)
#else:
print ('Processing data from tracking files')
sqlcon = gleaner.tracking_to_db(fname = ['tracking/Poisson_plane_p*.res'], \
                                dbname=dbname, tabname='plane')
# Simulation result
get_data_for_cols = ['coordX','coordY', 'potential_phy', 'analy_pot', 'error']
[x, y, pot, ana_pot, error] = gleaner.get_columns(sqlcon, tabname='plane', \
                             columns=get_data_for_cols)
x, y, pot, ana_pot, error = zip(*sorted(zip(x,y,pot,ana_pot,error))) # sort of needed
print('Convert gleaner list into numpy array')
import numpy as np
xnew = np.array([])
ynew = np.array([])
pot_new = np.array([])
ana_new = np.array([])
error_new = np.array([])
for i in range(len(x)):
  xnew = np.append(xnew,x[i][0])
  ynew = np.append(ynew,y[i][0])
  pot_new = np.append(pot_new,pot[i][0])
  ana_new = np.append(ana_new,ana_pot[i][0])
  error_new = np.append(error_new,error[i][0])
fig = plt.figure()
ax = fig.gca(projection='3d')
print('plot trisurf')
ax.plot_trisurf(xnew, ynew, pot_new, cmap=cm.coolwarm,
                     linewidth=0, antialiased=False)
plt.savefig('Numerical.png', dpi=100, format='png', \
             bbox_inches="tight",interpolation=None)


from numpy import pi,sinh,cos

# Make data.
#X = np.arange(0, 1, 1/100)
#Y = np.arange(0, 1, 1/100)
#X, Y = np.meshgrid(X, Y)
#R = np.sqrt(4+(np.pi**2))
#pot_analy = np.cos(np.pi*xnew)*((np.sinh(R*(1-ynew)))/(np.sinh(R)))
#print(len(Z))
##u = np.loadtxt('./tracking/Poisson_plane_p00000_t5.010E+00.res',usecols=[3])
##x = np.loadtxt('./tracking/Poisson_plane_p00000_t5.010E+00.res',usecols=[0])
## Plot the surface.
#surf = ax.plot_surface(X, Y,pot_new, cmap=cm.coolwarm,
#                       linewidth=0, antialiased=False)
fig = plt.figure()
ax = fig.gca(projection='3d')
ax.plot_trisurf(xnew, ynew, ana_new, cmap=cm.coolwarm,
                       linewidth=0, antialiased=False)

plt.savefig('Analytical.png', dpi=100, format='png', \
             bbox_inches="tight",interpolation=None)

fig = plt.figure()
ax = fig.gca(projection='3d')
ax.plot_trisurf(xnew, ynew, error_new, cmap=cm.coolwarm,
                       linewidth=0, antialiased=False)

plt.savefig('error.png', dpi=100, format='png', \
             bbox_inches="tight",interpolation=None)

plt.show()                      
