------------------------GEOMETRY PARAMETERS---------------------------
-- Height of the channel
halfHeight =  1.0 --m
height = 2*halfHeight
-- length to height ratio
l_h = 2.0
-- length of the channel
length = l_h*height
-- width of the channel
width = height/1.0
------------------------FLOW PARAMETERS---------------------------
-- Friction Reynolds number 
Re = 180*1
-- Kinematic viscosity
nu_p = 1.49e-5 --m^2/s
-- density
rho_p = 1.204 --kg/m^3
-- friction velocity
u_fric_p = Re * nu_p / halfHeight
-- characteristics length
delta_nu = nu_p / u_fric_p
-- characteristics time
T_c = halfHeight/u_fric_p
-- force
dpdx = rho_p*u_fric_p*u_fric_p/halfHeight
-- bulk mean velocity
y_plus_halfHeight = u_fric_p*halfHeight/nu_p
logterm = math.log(1.0+0.4*y_plus_halfHeight)/0.41
expterm = math.exp(-y_plus_halfHeight/11.0)
u_bulk = u_fric_p * (logterm+7.8*(1.0-expterm-y_plus_halfHeight/11.0*expterm))
-- Reynolds number at bulk
Re_bulk = u_bulk*height/nu_p
-- mean Reynolds number
-- Malaspinas, O., & Sagaut, P. (2014). Wall model for large-eddy simulation 
-- based on the lattice Boltzmann method. Journal of Computational Physics,
-- 275(October), 25–40.
Re_mean = (8/0.073)^(4.0/7.0) * Re^(8.0/7.0)
u_mean = Re_mean * nu_p / height
------------------------MESH PARAMETERS---------------------------
-- element size
dx = height/180--2*delta_nu*8
-- number of elements in height
nHeight = math.ceil(height/dx)
-- number of elements in length
nLength = nHeight*l_h 
-- length of the channel
length = nLength*dx
-- number of elements in bounding cube
--=number of elements in channel + inlet + outlet
nLength_bnd = nLength+2
-- level required to reach computed dx
level = math.ceil(math.log(nLength_bnd)/math.log(2))
-- length of the bounding cube
length_bnd = (2^level)*dx
-- level of wall
level_wall = level + 0

-- smallest possible element size
dx_eps = length_bnd/2^20
dx_half = dx*0.5
zpos = dx_half

