-- Musubi configuration file. 
-- This is a LUA script.

-- Local refinement settings
interpolation_method = 'copyfirst'
                     
ebug = {debugMode = false, debugFiles = true}
comm_reduced = true

-- Simulation name
simulation_name = 'gaussian'
mesh = 'mesh/'-- Mesh information
-- Time step settigs
tmax           = 8
time = {useIterations = true,
        min = 1, max = tmax, interval = tmax }
io_buffer_size = 1

originX =  -1.3
originY =  0.8
originZ =  0.1
halfwidth = 0.50
amplitude = 0.01
background = 1.0

function ic_1Dgauss_pulse(x, y, z, t)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*( x - originX )^2)
end
function ic_2Dgauss_pulse(x, y, z, t)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*(( x - originX )^2+( y - originY )^2))
end
scheme = {
{
-- Initial condition 
initial_condition = { density = ic_2Dgauss_pulse,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 },

fluid = { omega = 1.8, rho0 = 1.0 },
  identify = {
      label = 'debug_restart',
      kind = 'lbm', 
      layout = 'd3q19'
},


-- Boundary conditions
boundary_condition = {  
--{ label = 'east',
--  kind = 'wall', density = 1.0, order = 2 }
--  kind = 'outlet_nrbc', density = 1.0, sigma = 0.1, kappa = 1.2, L = 100. }
--{ label = 'right',
--   kind = 'outlet_extrapolation', density = 1.0, order = 3 }
--,{ label = 'west',
--   kind = 'wall', velocityX = 0.0001, velocityY = 0.0, velocityZ = 0.0, density = 1.0 }
--,{ label = 'north',
--   kind = 'wall', density = 1.0 }
--,{ label = 'south',
--   kind = 'wall', density = 1.0 }
--,
{ label = 'wall',
   kind = 'wall' }
},

-- Output settings
output = { active = false, -- VTK output activated?
  folder = 'output/',      -- Output location
  vtk = true,              -- VTK output activated?
  interval = 1, -- tmax/40,-- output interval 
  tmin = 1,                -- first iteration to output
  tmax = -1 }              -- last iteration to output

-- Tracking              
-- tracking = {
--  { label = 'probe_density', 
--  variables = {'density'}, 
--  type='point', point ={1.,0.,0.},
--  interval = 1, tmin = 0, tmax = -1 } 
--  }
} -- close the scheme
} -- close the scheme table

-- write restart
restart = { write = 'restart/',
            time = { min = -1, max = tmax, interval = 1}}
