require "common"

sim_control = {
  time_control = {
    max = { iter = tmax },
    interval = { iter = tmax/10 }
  },
}   -- sim_control

logging = {
  level = 6,
  --filename = simulation_name..'.log',
  root_only = false,
  real_form = 'EN5.3',
  int_form = 'I6',
} -- logging

estart = {
  read = 'restart/'..simulation_name..'_lastHeader.lua',
  --write = 'restart/',
  --time_control = {
  --  min = { iter = tmax },
  --  max = { iter = tmax },
  --  interval = { iter = 1 },
  --},
}

physics = {
  dt = dt,
  rho0 = densityPhy,
} -- physics table

identify = {
  kind = 'lbm_nNwtn',
  relaxation = 'bgk_pl',
  layout = 'd3q19',
}

-- add variables for analytical solutions
variable = {
  {
    name = 'p0Phy',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = p0Phy
  },
  {
    name = 'vel_x',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = {
      predefined = 'combined',
      temporal = {
        predefined = 'smooth',
        min_factor = velMaxPhy,
        max_factor = velMaxPhy,
        from_time  = 0,
        to_time    = tmaxPhy/4,
      },
      spatial = {
        predefined='parabol',
        shape = {
          kind = 'canoND',
          object = {
            origin = { -length/2+dx, -R, dx/2},
            vec = { 0.0, 2*R, 0.0 }
          }
        } -- shape table
      } -- spatial table
    }, -- st_fun table
  },
  {
    name = 'vel_y',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = 0.0
  },
  {
    name = 'vel_z',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = 0.0
  },
  {
    name = 'inlet_vel',
    ncomponents = 3,
    vartype = 'operation',
    operation = {
      kind = 'combine',
      input_varname = {
        'vel_x',
        'vel_y',
        'vel_z'
      },
    },
  },

  -- analytical solution
  { name='wssPL',    ncomponents=1, vartype = 'st_fun', st_fun = wssPL },
  { name='velPL',    ncomponents=1, vartype = 'st_fun', st_fun = velPL },
  { name='strainPL', ncomponents=1, vartype = 'st_fun', st_fun = strainPL },
  { name='velNew',   ncomponents=1, vartype = 'st_fun', st_fun = velA },
  { name='strainNew',ncomponents=1, vartype = 'st_fun', st_fun = strainRateA },
  { name='wssNew',   ncomponents=1, vartype = 'st_fun', st_fun = wssA },
  -- error
  { name = 'error_v', ncomponents = 1, vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'vel_mag_phy','velPL'}
    },
  },
  { name = 'relerror_v', ncomponents = 1, vartype = 'operation',
    operation = {
      kind = 'rel_difference',
      input_varname = {'vel_mag_phy','velPL'}
    },
  },
  { name = 'error_wss', ncomponents = 1, vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'wss_phy','wssPL'}
    },
  },
}

tracking = {
  { -- spatial across channel at last iteration
    label = 'spatial',
    variable = {
      'velocity_phy','velPL',
      'strain_rate_phy','strainPL',
      'wss_phy','wssPL',
      'omega',
      'shear_rate_phy',  -- 18
      -- Newtonian fluid profile, only for comparison
      'velNew', 'strainNew', 'wssNew', -- 19, 20, 21
      'error_v',
    }, -- variable
    shape = {
      kind = 'canoND',
      object = {
        origin = { 0.0, -height/2, dx/2},
        vec = { 0.0, height, 0.0},
        segments = {200},
      }
    }, -- shape
    time_control = {
      min = { iter = tmax },
      max = { iter = tmax },
      interval = { iter = tmax },
    },
    folder = './tracking/',
    output={format = 'asciiSpatial'}
  },
  { -- velocity l2norm
    label = 'vel_l2norm',
    variable = {
      'error_v',
      'velPL',
      'relerror_v'
    },
    shape = {
      kind = 'canoND',
      object = {
        origin = { 0.0, -height/2, dx/2},
        vec = { 0.0, height, 0.0},
        segments = {100}
      }
    },
    time_control = {
      min = { iter = 0 },
      max = { iter = tmax },
      interval = { iter = tmax / 10 },
    },
    reduction = {'l2norm', 'l2norm','l2norm'},
    folder = './tracking/', output={format = 'ascii'}
  },
  { -- wss l2norm
    label = 'wss_l2norm',
    variable = {
      'error_wss',
      'wssPL',
      --{ name = 'relDiff', ncomponents = 1, dep = {'wss_phy','wssPL'},},
    },
    shape = {
      kind = 'canoND',
      object = {
        origin = { 0.0, dx, dx/2 },
        vec = { 0.0, R, 0.0},
        segments = { 100 }
      }
    },
    time_control = {
      min = { iter = 0 },
      max = { iter = tmax },
      interval = { iter = tmax / 10 },
    },
    reduction = {'l2norm', 'l2norm'},
    folder = './tracking/', output={format = 'ascii'}
  },
  --{ -- results across channel over time
  --  label = 'over_time',
  --  variable = {
  --    --{'velocity_phy'},  {'velPL'},
  --    {'strainRate_phy'},{'strainPL'},
  --    --{'wss_phy'},       {'wssPL'},
  --  },
  --  shape = {
  --    kind = 'canoND',
  --    object = {
  --      origin = { 0.0, -height/2, dx/2},
  --      vec = { 0.0, height, 0.0},
  --      segments = {200},
  --    }
  --  }, -- shape
  --  time_control = {
  --    min = { iter = 0 },
  --    max = { iter = tmax },
  --    interval = { iter = tmax / 1000 },
  --  },
  --  folder = './tracking/',
  --  output={format = 'ascii'},
  --},
} -- tracking

fluid = {
  omega = omega,
  nonNewtonian = {
    model = 'power_law',
    n = n,
    k = viscPhy,
  },
}

initial_condition = {
  pressure = p0Phy,
  velocityX = velPL, velocityY = 0.0, velocityZ = 0.0,
  Sxx = 0, Syy = 0, Szz = 0, Sxy = strainRatePL, Syz = 0, Sxz = 0,
  omega = omega,
}

boundary_condition = {
  { label = 'outlet',kind = 'outlet_expol', pressure = 'p0Phy', }, -- outlet
  --{ label = 'inlet', kind = 'outlet_expol', pressure = p0Phy+dp, }, -- inlet
  { label = 'top_wall', kind = 'wall'},
  { label = 'bottom_wall', kind = 'wall'},
  {
    label = 'inlet',
    kind = 'inlet_ubb',
    velocity = 'inlet_vel'
  } -- inlet table
} -- boundary table



ebug = { 
  debugMode = true,  -- activate global debug modus
  debugFiles = true, -- open the debugFiles for each process dbgOut0000**.out
  --dumpDependencies = true, -- write the dependencies between levels to disk
  dumpAuxLists = true,
  logging = {
    level = 11, 
    filename = 'dbg', 
    root_only = false 
  },
}

