#!/bin/bash
# Evaluate the current test case

echo ----------------------------------------------------------
echo 2D Channel nonNewtonian flow of Power Law fluid Test case.
echo Author: Jiaixng Qi
echo Have fun!
date
echo ----------------------------------------------------------

export level=7
export Re=10
export n=0.5

# check necessary environment variables
# mesh refinement level
if [ -z "$level" ]; then
  echo "Please input mesh refine level ( from 6 to 10, try 7?):"
  echo " - level 6 generates 8  elements across channel"
  echo " - level 7 generates 16 elements across channel"
  echo " - level 8 generates 32 elements across channel"
  echo " - level 9 generates 64 elements across channel"
  read level_input
  export level=$level_input
fi

# Reynolds number
if [ -z "$Re" ]; then
  echo "Please input Reynolds number ( try 10?):"
  read Re_input
  export Re=$Re_input
fi

# nonNewtonian power law parameter n
if [ -z "$n" ]; then
  echo "Please input power law n (try 0.5?):"
  read n_input
  export n=$n_input
fi

# email address to receive results
if [ -z "$email" ]; then
  echo "Please input your email address (yourname@uni-siegen.de?):"
  read email_input
  export email=$email_input
fi

export results_tar=results.tar.gz

export spatial_file=tracking/results_spatial.res
export p_file=tracking/p_spatial.res
export inlet_file=tracking/inlet_spatial.res
export outlet_file=tracking/outlet_spatial.res

export vel_pic=pictures/vel_spatial.eps
export wss_pic=pictures/wss_spatial.eps
export strain_pic=pictures/strain_spatial.eps
export shear_pic=pictures/shear_spatial.eps
export omega_pic=pictures/omega_spatial.eps
export p_pic=pictures/pressureDrop.eps
export vel_along_pic=pictures/vel_along.eps
export bc_vel_pic=pictures/bc_vel.eps
export bc_strain_pic=pictures/bc_strain.eps
export bc_p_pic=pictures/bc_p.eps

export musubi_log=runMusubi.log.txt
export seeder_log=runSeeder.log.txt

# create folders and delete old results files
echo "Create directory mesh and tracking"
mkdir mesh
mkdir tracking
mkdir pictures
echo "Deleting old files (mesh, tracking)"
rm tracking/*.lua
rm tracking/*.res
rm mesh/*
rm pictures/*
rm ${musubi_log}
rm ${seeder_log}

$seeder | tee ${seeder_log}
mpirun -n 2 $musubi | tee ${musubi_log}
lua param.lua >> ${musubi_log}

cat tracking/*spatial*res >> ${spatial_file}
tar -czvf ${results_tar} tracking/*
cat tracking/*l2norm*res >> ${musubi_log}
gnuplot plot_spatial.gpl
python2.7 send_email.py
echo -------------------------------------------
echo nonNewtoninan power law flow finished!
date
