-- Use this file as template. Do not modify this file for running some testcases
refinePatch = false      -- square refinement around cylinder
refineCyl = false    -- refinement around cylinder (offset)

height =  0.41
nHeight = 64
l_h = 4
nLength = nHeight*l_h
dx = height/nHeight
length = nLength*dx
nLength_bnd = nLength+2
level = math.ceil(math.log(nLength_bnd)/math.log(2))
length_bnd = (2^level)*dx

dx_eps = length_bnd/2^20
dx_half = dx*0.5
zpos = dx_half
width = 1*dx
radius = 0.05
Dia = radius*2.0
offset_cyl = height/2

cylLevel = level
refineLevel = level
refineLength = length/3
if refinePatch then
  refineLevel = level+1
end

qVal = true
if refineCyl then
  cylLevel = refineLevel+1
end

folder = 'mesh/'--..subprefix
ebug = {debugMode = true, debugFiles=true}
timing_file = 'sdr_timing.res'

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx/1.,-dx/1.,-dx/1.},
               length = length_bnd}

minlevel = level

spatial_object = {
  {
    attribute = {
      kind = 'seed',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { dx, height*0.5, zpos },
        }
    }
  },
  {
    attribute = {
      kind = 'refinement',
      level = refineLevel
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { offset_cyl+0.1,height/4.0,-dx },
        vec = {{refineLength,0.0,0.0},
               {0.0,height/2.0,0.0},
               {0.0,0.0,height}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'north',
      --calc_dist = qVal
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { -dx/2,height+dx_eps,-dx/2 },
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,width+dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'south',
      --calc_dist = qVal
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx/2.0,-dx_eps,-dx/2.0},
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,width+dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'east'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length+dx_eps,-dx/2.0,-dx/2.0},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,width+dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'west'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx_eps,-dx/2.0,-dx/2.0},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,width+dx}}
        }
    }
  },
  {
    attribute = { 
      kind = 'boundary', 
      label = 'obst', 
      level = cylLevel,
      calc_dist = qVal, 
      flood_diagonal = true,
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = 'cylinder.stl'
      }
    },
    transformation = {
      deformation =  {radius,radius,radius },
      translation =  {offset_cyl+0.2, 0.2, 0. }
    }
  },
  {
    attribute = {
      kind = 'periodic',
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = {-dx_eps, -dx_eps, width+dx_eps},
          vec = {{length+2*dx_eps,0.0,0.0},
               {0.0,height+2*dx_eps,0.0}}
        },  --- plane1
        plane2 = {
          origin = {-dx_eps,-dx_eps,-dx_eps},
          vec = {{0.0,height+2*dx_eps,0.0},
                 {length+2*dx_eps,0.0,0.0}}
        } --- plane2
      }
    }
  },
--  {
--    attribute = {
--      kind = 'refinement',
--      level = minlevel + 1
--    },
--    geometry = {
--      kind = 'canoND',
--      object = {
--        origin = {2*length/3,-dx_eps+height/4,-dx/2.0},
--        --origin = {length/2, -2*dx,-dx/2.0},
--          vec = { {0.0,height/2,0.0} ,{length/4,0.0,0.0},{0,0.0,width+dx} },
--      }
--    }
--  },
}


