-- Musubi configuration file. 
-- This is a LUA script.
folderRead = 'restart_read/'
folderWrite = 'restart/'
require "seeder"

-- Simulation name
simulation_name = 'channel'
control_routine = 'debug'
mesh = 'mesh/'  -- Mesh information
-- Time step settings
tmax =  31  -- total iteration number
tRamping = tmax/2
interval = tmax/10
time = {useIterations = true,
        min = 1, max = tmax, interval = tmax}
u_in = 0.05

debug = { 
  verbosity    = 10,
  debugMode    = true, 
  debugFiles   = true,
  umpTreeIDs  = true,
  dumpAuxLists = true,
  umpState = true,
  checkDependencies = true,
--  debugMesh    = './debug/mesh_', 
--  debugStates  = { 
--  write = {
--    folder    = './debug/',    -- the folder the restart files are written to
--    interval  = 1,           -- dump restart file interval
--    tmin      = 1,           -- first timestep to output
--    tmax      = tmax+1       -- last timestep to output
--    }
-- }
 } 

-- Initial condition 
initial_condition = { pressure = 1.0, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

-- Boundary conditions
boundary_condition = {  
{ label = 'obst',
  kind = 'wall'},
{ label = 'inlet', 
  kind = 'inlet_ubb', 
  velocityX = u_in,
  order = 1,
--   { kind = 'combined',
--          temporal= {
--            predefined='smooth', 
--            min_factor = 0.0, 
--            max_factor=1.0, 
--            from_time=0, 
--            to_time=tRamping}, 
--          spatial = {
--            predefined='parabol', 
--            shape = { 
--              kind = 'canoND', 
--              object = {
--                origin = {-0.5*length, -(height-0.5*dx)*0.5, -(height-0.5*dx)*0.5},
--                vec = { {0.0, height-0.5*dx, 0.0 } , {0.0, 0.0, height-0.5*dx}}
--                } 
--             }
--            ,amplitude = u_in 
--      }         
--    },
 
  velocityY = 0.0, velocityZ = 0.0 }
,{ label = 'wall', kind = 'wall'} 
,{ label = 'outlet', 
  kind = 'outlet_expol', pressure = 1.1
  }
}

fluid = { omega = 1.8, rho0 = 1.0 }
  identify = {
      label = 'mini-channel',
      kind = 'lbm', 
      layout = 'd3q19', relaxation='bgk'}

-- Output settings
output = { active = true , -- VTU output activated?
  folder = './output/',     -- Output location
  vtu = true,             -- VTU output activated?
  ascii = false,          -- VTU output activated?
  dumpGhosts = true,
  dumpHalos = true,
  wss = false,
  shearstress = false,
  time = {min = tmax, max = tmax, interval = tmax}
}

-- Tracking              
tracking = {
  -- velocity profile over the channel height
  -- In the Poisseuille flow, this should be parabolic and depend on the pressure drop
{ label = 'velocityProfile',
  variable = {'velocity'},
  shape= { kind = 'canoND', object={origin ={  0., -20., 0.}, vec = {  0.,40.,0.} } },
  time = { min = tmax, max = tmax, interval = 1},
  format = 'asciiSpatial'
  },
{ label = 'pressureDrop',
  variable = {'pressure'}, 
  shape= { kind = 'canoND', object={origin ={-75., 0., 0.}, vec = {150.,0.,0.} } },
  time = { min = tmax, max = tmax, interval = 1},
  format = 'asciiSpatial'
  },
{ label = 'probePress', 
  variable = {'pressure'}, 
  shape= { kind = 'canoND', object={origin ={0., 0., 0.} } },
  time = { min = 0, max = tmax, interval = 20},
  format = 'ascii'
  },
{ label = 'totalDens', 
  variable = {'pressure'}, 
  reduction = {'sum'}, 
  shape= { kind = 'all', object={origin ={0., 0., 0.} } },
  time = { min = 0, max = tmax, interval = interval},
  folder = 'tracking/',
  format = 'ascii'
  },
  }

-- Restart settings
estart = {
  -- If this table is available it will write a restart file
  -- with the specified options.
  write = 'restart/', -- the folder the restart files are written to
  ead = 'restart/channel_lastHeader.lua',
  time = {min = tmax, max = tmax+1, interval = tmax}
}
-- Read or write?
if os.getenv('mode') == 'read' then
  print ('   READ MODE ')
restart = { read = folderWrite..'channel_header_00000000.000E+00.lua',
            write = folderRead,
            time = { min = 0, max = tmax, interval = tmax}}
elseif os.getenv('mode') == 'write' then
  print ('   WRITE MODE ')
restart = { 
            write = folderWrite,
            time = { min = 0, max = tmax, interval = tmax}}
end

