-- Use this file as template. Do not modify this file for running some testcases

-- Location to write the mesh in.
-- Note the trailing path seperator, needed, if all mesh files should be in a
-- directory. This directory has to exist before running Seeder in this case!
folder = 'mesh/'

-- Bounding cube: the root node of the octree, defining the complete universe,
-- from which all elements are derived by recursive bisection.
-- The origin is the corner from which on the cube is spanned with the given
-- length in each direction.
length = 150.
height = 20.


-- A minimum level, by which all parts in the computational domain should at
-- least be resolved with. Default is 0.
minlevel = 5
dx = length/2^minlevel
dxDash = dx*0.01

shift = {0.,0.,0.} --{length*0.5+dxDash, height*0.5+dxDash, height*0.5+dxDash}
debug = {debugMode = true}

fac = 0.35

bounding_cube = {origin = {-dxDash, -dxDash, -dxDash},
               length = length+2*dxDash}

-- *********************** Table of spatial objects *********************** --
-- Each spatial object is defined by an attribute and some geometric entity
-- attached to this attribute. Attributes might be defined multiple times.
-- Attributes are described by a kind (boundary, seed or refinement), a level
-- and maybe further kind specific values, like a label for the boundary.
-- Geometric objects might by right now:
-- - canoND (point, line, plane or box)
-- - STL
spatial_object = {
  {
    attribute = {
      kind = 'boundary',
      label='wall'
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = 'stl/wall.stl'
      }
    },
    transformation = {
     --   translation = shift, -- translate the geometry
      deformation = { fac,1.0,1.0}
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label='inlet'
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = 'stl/inlet.stl'
      }
    },
    tansformation = {
        translation = shift, -- translate the geometry
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label='outlet'
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = 'stl/outlet.stl'
      }
    },
    transformation = {
        translation = {-length+fac*length,0.0,0.0}, -- translate the geometry
--      deformation = { 0.25,1.0,1.0}
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'obst'
    },
    geometry = {
      kind = 'canoND',
      object = {{
        origin = { 5.0 ,0.0, 0.0 },
        vec = { height/2.0,height/2,height/2}
      },   
      {
        origin = {fac*length-5 ,0.0, 0.0 },
        vec = { -height/2.0,height/2,height/2}
      }
      }
    }
  },  
  {
    attribute = {
      kind = 'seed',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {fac*length/2.0,height/2,height/2}
      }
    },
    ransformation = {
        translation = {0.0,0.0,0.0} -- translate the geometry
    }
  }
}  

