-- Musubi configuration file. 
-- This is a LUA script.

-- Local refinement settings
--interpolation_method = 'copyfirst'
interpolation_method = 'average'
                     
debug = {debugMode = true, debugFiles = true}

-- Simulation name
simulation_name = 'gaussian'
mesh = 'mesh/'-- Mesh information
-- Time step settigs
tmax           = 10   
time = {useIterations = true,
        min = 1, max = tmax, interval = tmax }
io_buffer_size = 1

originX =  -1.3
originY =  0.8
originZ =  0.1
halfwidth = 0.50
amplitude = 0.01
background = 1.0

function ic_1Dgauss_pulse(x, y, z ,t)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*( x - originX )^2)
end
function ic_2Dgauss_pulse(x, y, z ,t)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*(( x - originX )^2+( y - originY )^2))
end

scheme = {
{
identify = {
            label = 'debug_tracking',
            kind = 'lbm',
            layout = 'd3q19',
            relaxation = 'bgk'},
-- Initial condition 
initial_condition = { pressure = ic_2Dgauss_pulse,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 },

fluid = { omega = 1.8, rho0 = 1.0 },

-- Boundary conditions
oundary_condition = {  
{ label = 'periodic_Z',
   kind = 'periodic' }
},

-- Output settings
output = { active = false, -- VTK output activated?
  folder = 'output/',      -- Output location
  vtu = true,              -- VTK output activated?
  ascii = false,            -- VTK output activated?
  time = {min = 0, max = -1, interval = 1} 
  }            

-- Tracking              
, tracking = {
  { label = 'line', 
  variable = {'pressure', 'velocity'}, 
  folder = 'tracking/',
   shape = {kind = 'canoND', object = { origin = {.0,-5.0,-2.5} , vec = {.0,10.0,0.}, segments = 100} } , 
                    
  time = {min = 0, max = 10, interval = 1}, 
  format = 'asciiSpatial' } 
  ,
  { label = 'hvs_plane', 
  variable = {'pressure', 'velocity'}, 
  folder = 'tracking/',
   shape = {kind = 'canoND', object = {origin = {-5.0,-5.0,.0} , vec = { {.0,10.0,0.}, {10.0,.0,0.} }, segments = {100,100}}},
--   shape = {kind = 'canoND', object = {origin = {.0,-5.0,-2.5} , vec = {.0,10.0,0.}, segments = 100}},
  time = {min = 0, max = 10, interval = 1}, 
  format = 'harvester' }, 
   { label = 'point', 
   variable = {'velocity','velMag'}, 
 --  reduction = {'sum','average'}, 
   folder = 'tracking/',
 --  shape = {kind = 'canoND', object = {origin = {0.,0.,0.}, vec = {1.0,0.,0.}, segments = {300} } },
   shape = {kind = 'canoND', object = {origin = {0.,0.,0.}}},
 --  shape = {{object = 'all'}},
   time = {min = 0, max = 10, interval = 1}, 
   format = 'ascii' },

  }
} -- close the scheme
} -- close the scheme table
-- Restart settings
estart = { ead = 'restart/gaussian_header_0002.000E+000000.lua',
            write = 'restart/',
            time = { min = -1, max = tmax, interval = 1}}
