require 'musubi'

print('-----------------------------------------------------------------------')
print('Simulation name: ', simulation_name)
print('-----------------------------------------------------------------------')
print('---Mesh parameters---')
print('length       =', length)
print('height       =', length)
print('nLength      =', length/dx)
-- Number of total elements
nElems = (length/dx)^3
print('nElems       =', nElems)
print('-----------------------------------------------------------------------')
print('---Flow parameters---')
print('---In physical units---')
print('Kinematic visc.   =', nu_phy, '[m^s/2]')
print('Density           =', rho0_phy, '[kg/m^3]')
print('Press. ambient    =', background, '[N/m^2]')
print('Element size (dx) =', dx, '[m]')
print('Time step (dt)    =', dt, '[s]')
-- Lattice viscosity
nu_lat = nu_phy * dt / dx^2
print('Lattice kinematic visc. =', nu_lat)
-- Lattice relaxation parameter
cs_lat = math.sqrt(1.0/3.0)
omega = 1.0 / ( nu_lat/cs_lat^2.0 + 0.5 )
print('Relaxation param.       =', omega)
print('-----------------------------------------------------------------------')
print('---Gaussian pulse parameters---')
print('Center of peak             =', center[1], ',', center[2], ',',center[3])
print('Height of peak (amplitude) =', amplitude)
print('Standard deviation         =', halfwidth)
print('Background pressure        =', background, '[N/m^2]')
