module tem_precice_module
  use, intrinsic :: iso_c_binding
  use env_module,                       only: rk, labelLen, globalMaxLevels
  use aotus_module,                     only: flu_State, aot_get_val, &
   &                                          aoterr_NonExistent, aoterr_fatal
  use aot_table_module,                 only: aot_table_open, aot_table_close
  use aot_table_ops_module,             only: aot_table_length
  use tem_logging_module,               only: logUnit
  use tem_aux_module,                   only: tem_abort, tem_open_distconf
  use tem_tools_module,                 only: upper_to_lower
  use tem_time_module,                  only: tem_time_type
  use tem_operation_module,             only: tem_indexLvl_type
  use tem_precice_interpolation_module, only: tem_interpolation_type

  implicit none

  private

  logical , parameter :: precice_available= .false.

  type tem_precice_type
    ! general info for precice
    ! name of solver, should be indetical to name in precice_configeFile
    character(len=labelLen) :: accessor
    character(len=labelLen) :: precice_configFile
    !> for initialize data for precice
    integer :: action_isrequired
    !> for exchanging data in intermediate timestep, when using ssprk2
    logical :: use_RK2_inter
  end type tem_precice_type

  !> since points on the bc could be level depended also the positions ID are
  !! levelwise
  type tem_precice_posIDlvl
    !> position IDs for the exchange points, which are unquie per meshID
    !! dimension is npnts on that level
    integer, allocatable :: posIDs(:)
  end type tem_precice_posIDlvl

 !> data type which consists of information for the variables to
  !! couple with precice
  type tem_precice_varInfo
    !> coupling is done via surface, and the ID is the precice given ID of that
    !! surface, which is required for read and write to precice, when using
    !non-equidistant poins, thus we provide for read and write different meshIDs
    integer :: meshID
    !> number of variables to read from precice
    integer :: nVars
    !> name of tha variable which need to be coupled
    character(len=labelLen), allocatable :: Names(:)
    !> name of variable is converted to data ID, which is unquie in precice
    integer, allocatable :: IDs(:)
    !> varPos in the ateles variable system
    integer, allocatable :: varPos(:)
    !> type which contains the posIDs levelwise, this is important to be here,
    !when using equidistant points, since we provide different meshes, thus we
    !also need different posIDs for them
    type(tem_precice_posIDlvl) :: posIDLvl(globalMaxLevels)
  end type tem_precice_varInfo

  !> datatype stored all information required for the coupled variable
  type tem_precice_coupling_type
    ! label for the ateles boundary to write from and read to
    ! required to get the correct exchange points during initialization
    character(len=labelLen) :: boundary
    !> flag for reading from precice
    logical :: read = .false.
    !> flag for writing to  precice
    logical :: write = .false.
    !> data type to store variabels to precice.
    !> data type to stroe variable information to read from precice
    type (tem_precice_varInfo) :: readVar
    !> data type to stroe variable information to read from precice
    type (tem_precice_varInfo) :: writeVar
    !> type which contains indices to access point position
    type(tem_indexLvl_type) :: pntIndex
    type(tem_interpolation_type) :: interpolation
  end type tem_precice_coupling_type

  type(tem_precice_type) :: precice

  interface tem_precice_read
    module procedure tem_precice_read_scalar
    module procedure tem_precice_read_vector
  end interface tem_precice_read

  interface tem_precice_write
    module procedure tem_precice_write_scalar
    module procedure tem_precice_write_vector
  end interface tem_precice_write

  public :: precice_available
  public :: precice
  public :: tem_precice_coupling_type
  public :: tem_precice_load, tem_precice_init, tem_precice_create
  public :: tem_precice_advance
  public :: tem_precice_finalize
  public :: tem_precice_ongoing
  public :: tem_precice_read
  public :: tem_precice_write
  public :: tem_precice_set_vertex_pos
  public :: tem_precice_set_vertices_pos
  public :: tem_precice_set_edge
  public :: tem_precice_set_triangle
  public :: tem_precice_action_required
  public :: tem_precice_action_write_initData
  public :: tem_precice_action_write_iter_checkp
  public :: tem_precice_action_read_iter_checkp
  public :: tem_precice_initialize_data
  public :: tem_precice_fulfilled_Action
  public :: tem_precice_initmeshID
  public :: tem_precice_get_DataIDs
  public :: tem_precice_load_coupling


contains


  ! ************************************************************************ !
  subroutine tem_precice_load( conf )
    ! -------------------------------------------------------------------- !
    !> The filename to read the configuration from.
    type(flu_state), intent(in) :: conf
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_load
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_create( rank, comm_size )
    ! -------------------------------------------------------------------- !
    integer, intent(in) :: rank
    integer, intent(in) :: comm_size
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_create
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_load_coupling( me, conf, thandle )
    ! -------------------------------------------------------------------- !
    !> The coupling type which should be filled
    type(tem_precice_coupling_type), intent(out) :: me
    !> Lua script to obtain the configuration data from.
    type(flu_State), intent(in) :: conf
    !> Boundary condition sub table
    integer, intent(in) :: thandle
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_load_coupling
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_get_DataIDs( dataName, dataID, meshID )
    ! -------------------------------------------------------------------- !
    character(len=labelLen), intent(in) :: dataName
    integer, intent(inout) :: dataID
    integer, intent(in) :: meshID
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_get_DataIDs
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_initmeshID( meshName, meshID )
    ! -------------------------------------------------------------------- !
    character(len=labelLen) :: meshName
    integer :: meshID
    ! -------------------------------------------------------------------- !

  end subroutine tem_precice_initmeshID
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_init( timesteplimit )
    ! -------------------------------------------------------------------- !
    real(kind=rk), intent(inout) :: timestepLimit
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_init
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_initialize_data()
  end subroutine tem_precice_initialize_data
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_advance( timestepLimit )
    ! -------------------------------------------------------------------- !
    real(kind=rk), intent(inout) :: timestepLimit
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_advance
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_finalize()
  end subroutine tem_precice_finalize
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_ongoing( isOngoing )
    ! -------------------------------------------------------------------- !
    integer, intent(inout) :: isOngoing
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_ongoing
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_action_write_initData( nameAction )
    ! -------------------------------------------------------------------- !
    character(len=labelLen), intent(inout) :: nameAction
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_action_write_initData
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_action_write_iter_checkp( nameAction )
    ! -------------------------------------------------------------------- !
    character(len=labelLen), intent(inout) :: nameAction
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_action_write_iter_checkp
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_action_read_iter_checkp( nameAction )
    ! -------------------------------------------------------------------- !
    character(len=labelLen), intent(inout) :: nameAction
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_action_read_iter_checkp
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_fulfilled_Action( nameAction )
    ! -------------------------------------------------------------------- !
    character(len=labelLen), intent(in) :: nameAction
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_fulfilled_Action
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_action_required( NameAction, isRequired )
    ! -------------------------------------------------------------------- !
    character(len=labelLen), intent(in) :: NameAction
    integer, intent(out) :: isRequired
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_action_required
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_set_read_pos( meshID ,position, positionID )
    ! -------------------------------------------------------------------- !
    integer, intent(in) :: meshID
    real(kind=rk), intent(in) :: position(3)
    integer, intent(out) :: positionID
    ! -------------------------------------------------------------------- !
  endsubroutine tem_precice_set_read_pos
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_set_vertex_pos( meshID, npoints, points, positionID )
    ! -------------------------------------------------------------------- !
    integer, intent(in) :: meshID
    integer, intent(in) :: npoints
    real(kind=rk), intent(in) :: points(npoints*3)
    integer, intent(out) :: positionID(npoints)
    ! -------------------------------------------------------------------- !
  endsubroutine tem_precice_set_vertex_pos
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_set_vertices_pos( meshID, npoints, points, positionID )
    ! -------------------------------------------------------------------- !
    integer, intent(in) :: meshID
    integer, intent(in) :: npoints
    real(kind=rk), intent(in) :: points(3*npoints)
    integer, intent(out) :: positionID(npoints)
    ! -------------------------------------------------------------------- !
  endsubroutine tem_precice_set_vertices_pos
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_set_write_pos( meshID, position, positionID )
    ! -------------------------------------------------------------------- !
    integer, intent(in) :: meshID
    real(kind=rk), intent(in) :: position(3)
    integer, intent(out) :: positionID
    ! -------------------------------------------------------------------- !
  endsubroutine tem_precice_set_write_pos
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_set_edge( meshID, firstVertexID, secondVertexID, &
    &                              edgeID                                 )
    ! -------------------------------------------------------------------- !
    integer, intent(in) :: meshID
    integer, intent(in) :: firstVertexID
    integer, intent(in) :: secondVertexID
    integer, intent(out) :: edgeID
    ! -------------------------------------------------------------------- !
  endsubroutine tem_precice_set_edge
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_set_triangle( meshID, firstEdgeID, secondEdgeID, &
    &                                  thirdEdgeID                        )
    ! -------------------------------------------------------------------- !
    integer, intent(in) :: meshID
    integer, intent(in) :: firstEdgeID
    integer, intent(in) :: secondEdgeID
    integer, intent(in) :: thirdEdgeID
    ! -------------------------------------------------------------------- !
  endsubroutine tem_precice_set_triangle
  ! ************************************************************************ !


  ! ************************************************************************ !
  function tem_precice_read_scalar( dataID, posIDs, npoints ) result( res )
    ! -------------------------------------------------------------------- !
    integer, intent(in) :: npoints
    integer, intent(in) :: dataID
    integer, intent(in) :: posIDs(npoints)
    real(kind=rk) :: res(npoints) !< return value
    ! -------------------------------------------------------------------- !
    ! To avoid a return-type compiler warning, we set the result
    res = 0.0_rk
  end function tem_precice_read_scalar
  ! ************************************************************************ !


  ! ************************************************************************ !
  function tem_precice_read_vector( dataID, posID, npoints, nscalar, vector ) &
    &                               result( res )
    ! -------------------------------------------------------------------- !
    integer, intent(in) :: dataID
    integer, intent(in) :: posID(:)
    integer, intent(in) :: nscalar
    integer, intent(in) :: npoints
    logical, intent(in) :: vector
    real(kind=rk) :: res(npoints,nscalar) !< return value
    ! -------------------------------------------------------------------- !
    ! To avoid a return-type compiler warning, we set the result
    res = 0.0_rk
  end function tem_precice_read_vector
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_write_scalar( dataID, posID, npoints, val )
    !------------------------------------------------------------------------
    integer, intent(in) :: npoints
    integer, intent(in) :: dataID
    integer, intent(in) :: posID(npoints)
    real(kind=rk), intent(in) :: val(npoints)
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_write_scalar
  ! ************************************************************************ !


  ! ************************************************************************ !
  subroutine tem_precice_write_vector( dataID, posID, npoints, nscalar, val )
    ! -------------------------------------------------------------------- !
    integer, intent(in) :: dataID
    integer, intent(in) :: posID(:)
    integer, intent(in) :: npoints
    integer, intent(in) :: nscalar
    real(kind=rk), intent(in) :: val(nscalar,npoints)
    ! -------------------------------------------------------------------- !
  end subroutine tem_precice_write_vector
  ! ************************************************************************ !

end module tem_precice_module
