import os
import sequencer

__author__ = "Peter Vitt"
__copyright__ = "Copyright 2017, University of Siegen"
__version__ = "0.0.1"

class Module(object):

    def __init__(self, filepath):
        self._file = filepath
        self.Name = os.path.splitext(os.path.basename(filepath))[0]

    def _get_lines(self):
        """Read all lines from _file"""
        # read all lines from file
        with open(self._file, 'r') as f:
            lines = f.readlines()
        # strip whitespace from line endings
        return [x.strip() for x in lines]

    def getPublicSymbols(self):
        lines = sequencer.make_long_lines(self._get_lines())

        all_private = any([True for l in lines if l == 'private'])
        if all_private:
            return sequencer.get_publics(lines)
        else:
            # Module is not private by default, thus we have to append all
            # module's top level items
            print("Not yet implemented: Module "
                    + self.Name
                    + " is not private by default, thus we"
                    " have to append all module's top level items!")
            return []


    def getUses(self):
        lines = self._get_lines()
        return sequencer.get_uses(lines)

    def getCombinedLines(self):
        return sequencer.make_long_lines(self._get_lines())

    def getTypes(self):
        lines = self._get_lines()
        return sequencer.get_types(lines)
