! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module encapsulates the available isNaN implementation
!!
!! Here we use the IEEE implementation specified by the F2003
!! standard, as it is supported by the compiler.
!!
module tem_isNaN_module

  ! include treelm modules
  use, intrinsic :: ieee_arithmetic, only: ieee_is_nan
  use env_module, only: rk

  implicit none

  private

  public :: tem_isNaN

  contains

! ****************************************************************************** !
  !> todo: Add description
  !!
  elemental function tem_isNaN(num) result(noNumber)
    !---------------------------------------------------------------------------
    real(kind=rk), intent(in) :: num
    logical :: noNumber
    !---------------------------------------------------------------------------

    noNumber = ieee_is_NaN(num)

  end function tem_isNaN
! ****************************************************************************** !


end module tem_isNaN_module
! ****************************************************************************** !
